using System.Linq;
using System.Threading.Tasks;
using log4net.Appender;
using log4net.Repository.Hierarchy;
using Action = System.Action;

#region References

using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Drawing;
using System.IO;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using Spring.Context.Support;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.Common.AppServices;
using gov.va.med.vbecs.Common.DependencyInjection;
using gov.va.med.vbecs.Common.Log;
using gov.va.med.vbecs.DAL.HL7AL;
using gov.va.med.vbecs.DAL.VAL;
using gov.va.med.vbecs.DAL.VistALink.Client;
using gov.va.med.vbecs.ExceptionManagement;
using gov.va.med.vbecs.GUI.Lock;
using gov.va.med.vbecs.Lock;

#endregion

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Application main form
	/// </summary>
	public class FrmVbecs : FrmAppMainFormBase
	{		
		#region Variables

        //log4net
        private static ILogger _logger;

		private const int WM_CLOSE = 0x0010;		

		private bool _vistalinkAvailable;
		private bool _orderAlertIcon;
		private bool _patientAlertIcon;
		
		private bool _disableTimers;
		private bool _formFirstTimeActivated; 

		private TextBoxBase _editMenuTextBox;

		// *************************************************************************************************
		// UC_84 variables
		private const int VBECS_PATIENT_ALERT_REFRESH = 300000; // 5 min as milliseconds
		
		private DateTime _lastPatientUpdateCheck;
		private DateTime _lastOrderUpdateCheck;

		private StringBuilder _patientAlertToolTip;

		private BOL.Division _division;

		private Thread _orderIconThread;
		private Thread _patientIconThread;

		private FrmMergePatients _frmMergePatients;
		private FrmViewUpdatedPatients _frmViewUpdatedPatients;
		private FrmViewDeceasedPatients _frmViewDeceasedPatients;
		// *************************************************************************************************

		// Used for purging the HL7 MessageLog
		// CR 2519
		private Thread _purgeMessageLogThread;

		// Used for sending extracts to Dss
		// CR 2958
		private Thread _dssExtractThread;
		
		/// <summary>
		/// Short text of the division time zone
		/// </summary>
		private string _divisionTimeZoneText;
		private DateTime _displayDateTime;
		private TimeSpan _serverTimeDifference;

		#endregion
					
		#region Form Controls

		private System.Windows.Forms.StatusBar statusBar1;
		private System.Windows.Forms.StatusBarPanel statusBarPanelDivision;
		private System.Windows.Forms.StatusBarPanel statusBarPanelTimeZone;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.StatusBarPanel statusBarPanelUser;
		private System.Windows.Forms.StatusBarPanel statusBarPanelVistALink;
		private System.Windows.Forms.MainMenu mnuMain;
		private System.Windows.Forms.MenuItem mnuFile;
		private System.Windows.Forms.MenuItem mnuChangeDivision;
		private System.Windows.Forms.MenuItem mnuSplit1;
		private System.Windows.Forms.MenuItem mnuExit;
		private System.Windows.Forms.MenuItem mnuHelp;
		private System.Windows.Forms.ImageList imglistSmall;
		private System.Windows.Forms.ImageList imglistLarge;
		private System.Windows.Forms.MenuItem mnuBloodUnits;
		private System.Windows.Forms.MenuItem mnuBloodAvailability;
		private System.Windows.Forms.MenuItem mnuShipment;
		private System.Windows.Forms.MenuItem mnuPatients;
		private System.Windows.Forms.MenuItem mnuOrders;
		private System.Windows.Forms.MenuItem mnuReagents;
		private System.Windows.Forms.MenuItem mnuTools;
		private System.Windows.Forms.MenuItem mnuModifyUnits;
		private System.Windows.Forms.MenuItem mnuGenerateLabel;
		private System.Windows.Forms.MenuItem mnuABORhConfirmation;
		private System.Windows.Forms.MenuItem mnuEditFinancialData;
		private System.Windows.Forms.MenuItem mnuDiscardQuarantineRelease;
		private System.Windows.Forms.MenuItem mnuSIAndTRs;
		private System.Windows.Forms.MenuItem mnuIncomingShipment;
		private System.Windows.Forms.MenuItem mnuShipmentABORhConfirmation;
		private System.Windows.Forms.MenuItem mnuInvoiceDiscardQuarantineRelease;
		private System.Windows.Forms.MenuItem mnuOutgoingShipment;
		private System.Windows.Forms.MenuItem mnuAcceptOrders;
		private System.Windows.Forms.MenuItem mnuSpecimen;
		private System.Windows.Forms.MenuItem mnuOrderReflexTests;
		private System.Windows.Forms.MenuItem mnuConfigureDailyQC;
		private System.Windows.Forms.MenuItem mnuEnterDailyQCResults;
		private System.Windows.Forms.MenuItem mnuLoginReagents;
		private System.Windows.Forms.MenuItem mnuUpdateInventory;
		private System.Windows.Forms.MenuItem mnuViewPrintInventory;
		private System.Windows.Forms.MenuItem mnuMaintainMinLevels;
		private System.Windows.Forms.MenuItem mnuAntibodies;
		private System.Windows.Forms.MenuItem mnuBloodProducts;
		private System.Windows.Forms.MenuItem mnuCannedComments;
		private System.Windows.Forms.MenuItem mnuCollectionFacilities;
		private System.Windows.Forms.MenuItem mnuComponentClasses;
		private System.Windows.Forms.MenuItem mnuMSBOS;
		private System.Windows.Forms.MenuItem mnuTransfusionComplicationns;
		private System.Windows.Forms.MenuItem mnuTransfusionEffectiveness;
		private System.Windows.Forms.MenuItem mnuWorkloadCodes;
		private System.Windows.Forms.MenuItem mnuEditInvoiceText;
		private System.Windows.Forms.MenuItem mnuConfigureDivision;
		private System.Windows.Forms.MenuItem mnuUpdateUsers;
		private System.Windows.Forms.MenuItem mnuSplit2;
		private System.Windows.Forms.MenuItem mnuNewOutgoingShipment;
		private System.Windows.Forms.MenuItem mnuRecentOutgoingShipmennt;
		private System.Windows.Forms.MenuItem mnuReports;
		private System.Windows.Forms.MenuItem mnuPatientTesting;
		private System.Windows.Forms.MenuItem mnuMedicationProfile;
		private System.Windows.Forms.MenuItem mnuUnitAntigenTyping;
		private System.Windows.Forms.MenuItem mnuPatientBloodAvailability;
		private System.Windows.Forms.MenuItem mnuPrintTagFormPatient;
		private System.Windows.Forms.MenuItem mnuPrintTagFormUnit;
		private System.Windows.Forms.MenuItem mnuSplit3;
		private System.Windows.Forms.MenuItem mnuPrintBackupForms;
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.MenuItem mnuReleaseUnitsFromPatientAssignment;
		private System.Windows.Forms.MenuItem mnuReleaseUnitsFromAssignment;
		private System.Windows.Forms.MenuItem mnuRemoveFinalUnitStatus;
		private System.Windows.Forms.MenuItem mnuEditUnitInformation;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem mnuIssueBlood;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem mnuAuditTrail;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem mnuInvalidatePatientTesting;
		private System.Windows.Forms.MenuItem mnuEdit;
		private System.Windows.Forms.MenuItem mnuCut;
		private System.Windows.Forms.MenuItem mnuCopy;
		private System.Windows.Forms.MenuItem mnuPaste;
		
		private System.Windows.Forms.MenuItem mnuUndo;
		private System.Windows.Forms.MenuItem mnuSplit4;
		private System.Windows.Forms.MenuItem mnuDelete;
		private System.Windows.Forms.MenuItem mnuSplit5;
		private System.Windows.Forms.MenuItem mnuSelectAll;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem mnuExceptionReport;
		private System.Windows.Forms.MenuItem mnuReturnIssuedUnits;
		private System.Windows.Forms.MenuItem mnuReturnIssuedUnitsForPatient;
		private System.Windows.Forms.MenuItem mnuFreeDirectedUnit;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem mnuJustifyABORhChange;
		private System.Windows.Forms.MenuItem menuItem7;
		private System.Windows.Forms.MenuItem menuItem8;
		private System.Windows.Forms.MenuItem menuItem9;
		private System.Windows.Forms.MenuItem menuItem10;
		private System.Windows.Forms.MenuItem mnuPatientUpdates;
		private System.Windows.Forms.MenuItem mnuPatientMerge;
		private System.Windows.Forms.MenuItem mnuUpdatedPatients;
		private System.Windows.Forms.MenuItem mnnuDeceasedPatients;
		private System.Windows.Forms.MenuItem mnuTransfusionReactionHistory;
		private System.Windows.Forms.MenuItem mnuRecentTransfusionIssues;
		private System.Windows.Forms.MenuItem mnuRecentOrders;
		private System.Windows.Forms.MenuItem menuItem11;
		private System.Windows.Forms.MenuItem mnuRecentPatientOrders;
		private System.Windows.Forms.MenuItem menuItem15;
		private System.Windows.Forms.MenuItem mnuSelectUnits;
		private System.Windows.Forms.MenuItem mnuTestingWorklist;
		private System.Windows.Forms.MenuItem mnuPostTransfusionDetails;
		private System.Windows.Forms.StatusBarPanel statusBarPanelOrderAlert;
		private System.Windows.Forms.StatusBarPanel statusBarPanelPatientAlert;
		private System.Windows.Forms.ContextMenu cmnuPatientUpdates;
		private System.Windows.Forms.MenuItem mnuUpdatedPatientsToolbar;
		private System.Windows.Forms.MenuItem mnuDeceasedPatientToolbar;
		private System.Windows.Forms.MenuItem mnuPatientMergeToolbar;
		private System.Windows.Forms.MenuItem mnuSupervisor;
		private System.Windows.Forms.MenuItem mnuDocumentABOIncompatibleTransfusion;
		private System.Windows.Forms.ToolBar tbVBECS;
		private System.Windows.Forms.ImageList imgToolbar;
		private System.Windows.Forms.ToolBarButton tbtnLoginReagents;
		private System.Windows.Forms.ToolBarButton tbtnDailyQC;
		private System.Windows.Forms.ToolBarButton tbtnSpacer1;
		private System.Windows.Forms.ToolBarButton tbtnIncomingShipment;
		private System.Windows.Forms.ToolBarButton tbtnModifyUnits;
		private System.Windows.Forms.ToolBarButton tbtnOutgoingShipment;
		private System.Windows.Forms.ToolBarButton tbtnSpacer2;
		private System.Windows.Forms.ToolBarButton tbtnAcceptOrders;
		private System.Windows.Forms.ToolBarButton tbtnMaintainSpecimen;
		private System.Windows.Forms.ToolBarButton tbtnPatientTesting;
		private System.Windows.Forms.ToolBarButton tbtnSelectUnits;
		private System.Windows.Forms.ToolBarButton tbtnIssueUnits;
		private System.Windows.Forms.ToolBarButton tbtnUnitConfirmation;
		private System.Windows.Forms.ToolBarButton tbtnUnitTyping;
		private System.Windows.Forms.ToolBarButton tbtnTransfusionInfo;
		private System.Windows.Forms.MenuItem mnuDivisionTransfusionReport;
		private System.Windows.Forms.MenuItem mnuCTRatioReport;
		private System.Windows.Forms.MenuItem mnuBloodUnitDataReport;
		private System.Windows.Forms.Timer tmrPatientAlerts;
		private System.Windows.Forms.Timer tmrOrderAlerts;
		private System.Windows.Forms.ListView lvOrders;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.Panel pnlOrders;
		private System.Windows.Forms.Label lblOrders;
		private System.Windows.Forms.Button btnCloseOrders;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.MenuItem mnuSupplies;
		private System.Windows.Forms.MenuItem mnuLogInSupplies;
		private System.Windows.Forms.MenuItem mnuUpdateSupplyInventory;
		private System.Windows.Forms.MenuItem mnuViewPrintSupplyInventory;
		private System.Windows.Forms.MenuItem mnuEquipment;
		private System.Windows.Forms.MenuItem mnuLogInEquipment;
		private System.Windows.Forms.MenuItem mnuMaintainEquipment;
		private System.Windows.Forms.MenuItem mnuCostAccountingReport;
		private System.Windows.Forms.MenuItem mnuIssuedReturnedReport;
		private System.Windows.Forms.MenuItem mnuFinalizePrintTrw;
		private System.Windows.Forms.MenuItem mnuDivisionWorkloadReport;
		private System.Windows.Forms.MenuItem mnuUnitHistoryReport;
		private System.Windows.Forms.MenuItem mnuTransfusionRequirementsReport;
		private System.Windows.Forms.MenuItem mnuTransfusionComplicationsReport;
		private System.Windows.Forms.MenuItem mnuTransfusionEffectivenessReport;
		private System.Windows.Forms.MenuItem mnuInappropriateRequestReport;
		private System.Windows.Forms.MenuItem mnuPatientHistoryReport;
		private System.Windows.Forms.MenuItem mnuPatientRecordReport;
		private System.Windows.Forms.MenuItem mnuProlongedTransfusionReport;
		private System.Windows.Forms.MenuItem mnuTransfusionReactionCountReport;
		private System.Windows.Forms.MenuItem mnuAdministrativeDataReport;
		private System.Windows.Forms.MenuItem mnuOrderHistoryReport;
		private System.Windows.Forms.MenuItem mnuOrderDataReport;
		private System.Windows.Forms.Timer tmrDateTime;
		private System.Windows.Forms.MenuItem mnuAbout;
		private System.Windows.Forms.MenuItem mnuVBECSHelp;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.ColumnHeader columnHeader9;
		private System.Windows.Forms.MenuItem mnuPatientTestingWorklist;
	

		#endregion

		#region Constructor / Destructor

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmVbecs()
		{
			InitializeComponent();

			this.vbecsLogo1.Visible = false;
			this.lblRequiredField.Visible = false;

			_editMenuTextBox = null;
			_formFirstTimeActivated = true;
			_disableTimers = false;

			// Order Alerts timer interval defined by division, have to log in before setting it
			this.tmrPatientAlerts.Interval = VBECS_PATIENT_ALERT_REFRESH;
			
		
#if DEBUG
			mnuFile.MenuItems.Add( new MenuItem( "DEBUG: Stop VistALink", new EventHandler( DebugStopVistALink_Click ) ) );
			mnuFile.MenuItems.Add( new MenuItem( "DEBUG: Run Long VistALink Query", new EventHandler( DebugRunLongVistALinkQuery_Click ) ) );
#endif
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing && components != null )
				components.Dispose();

			base.Dispose( disposing );
		}

		#endregion

		#region Windows Form Designer generated code

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmVbecs));
			this.imglistLarge = new System.Windows.Forms.ImageList(this.components);
			this.imglistSmall = new System.Windows.Forms.ImageList(this.components);
			this.statusBar1 = new System.Windows.Forms.StatusBar();
			this.statusBarPanelUser = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanelDivision = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanelTimeZone = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanelOrderAlert = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanelPatientAlert = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanelVistALink = new System.Windows.Forms.StatusBarPanel();
			this.mnuMain = new System.Windows.Forms.MainMenu();
			this.mnuFile = new System.Windows.Forms.MenuItem();
			this.mnuChangeDivision = new System.Windows.Forms.MenuItem();
			this.mnuSplit1 = new System.Windows.Forms.MenuItem();
			this.mnuExit = new System.Windows.Forms.MenuItem();
			this.mnuEdit = new System.Windows.Forms.MenuItem();
			this.mnuUndo = new System.Windows.Forms.MenuItem();
			this.mnuSplit4 = new System.Windows.Forms.MenuItem();
			this.mnuCut = new System.Windows.Forms.MenuItem();
			this.mnuCopy = new System.Windows.Forms.MenuItem();
			this.mnuPaste = new System.Windows.Forms.MenuItem();
			this.mnuDelete = new System.Windows.Forms.MenuItem();
			this.mnuSplit5 = new System.Windows.Forms.MenuItem();
			this.mnuSelectAll = new System.Windows.Forms.MenuItem();
			this.mnuBloodUnits = new System.Windows.Forms.MenuItem();
			this.mnuGenerateLabel = new System.Windows.Forms.MenuItem();
			this.mnuPrintTagFormUnit = new System.Windows.Forms.MenuItem();
			this.menuItem7 = new System.Windows.Forms.MenuItem();
			this.mnuABORhConfirmation = new System.Windows.Forms.MenuItem();
			this.mnuUnitAntigenTyping = new System.Windows.Forms.MenuItem();
			this.mnuModifyUnits = new System.Windows.Forms.MenuItem();
			this.mnuSelectUnits = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.mnuDiscardQuarantineRelease = new System.Windows.Forms.MenuItem();
			this.mnuFreeDirectedUnit = new System.Windows.Forms.MenuItem();
			this.mnuReleaseUnitsFromPatientAssignment = new System.Windows.Forms.MenuItem();
			this.mnuReturnIssuedUnits = new System.Windows.Forms.MenuItem();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.mnuEditFinancialData = new System.Windows.Forms.MenuItem();
			this.mnuEditUnitInformation = new System.Windows.Forms.MenuItem();
			this.mnuBloodUnitDataReport = new System.Windows.Forms.MenuItem();
			this.mnuPatients = new System.Windows.Forms.MenuItem();
			this.mnuRecentOrders = new System.Windows.Forms.MenuItem();
			this.mnuPatientBloodAvailability = new System.Windows.Forms.MenuItem();
			this.mnuRecentTransfusionIssues = new System.Windows.Forms.MenuItem();
			this.menuItem11 = new System.Windows.Forms.MenuItem();
			this.mnuPatientTesting = new System.Windows.Forms.MenuItem();
			this.mnuPatientTestingWorklist = new System.Windows.Forms.MenuItem();
			this.mnuPrintTagFormPatient = new System.Windows.Forms.MenuItem();
			this.mnuIssueBlood = new System.Windows.Forms.MenuItem();
			this.mnuPostTransfusionDetails = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.mnuReleaseUnitsFromAssignment = new System.Windows.Forms.MenuItem();
			this.mnuReturnIssuedUnitsForPatient = new System.Windows.Forms.MenuItem();
			this.mnuInvalidatePatientTesting = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.mnuSIAndTRs = new System.Windows.Forms.MenuItem();
			this.mnuTransfusionReactionHistory = new System.Windows.Forms.MenuItem();
			this.menuItem10 = new System.Windows.Forms.MenuItem();
			this.mnuPatientRecordReport = new System.Windows.Forms.MenuItem();
			this.mnuPatientUpdates = new System.Windows.Forms.MenuItem();
			this.mnuPatientMerge = new System.Windows.Forms.MenuItem();
			this.mnuUpdatedPatients = new System.Windows.Forms.MenuItem();
			this.mnnuDeceasedPatients = new System.Windows.Forms.MenuItem();
			this.mnuShipment = new System.Windows.Forms.MenuItem();
			this.mnuIncomingShipment = new System.Windows.Forms.MenuItem();
			this.mnuOutgoingShipment = new System.Windows.Forms.MenuItem();
			this.mnuNewOutgoingShipment = new System.Windows.Forms.MenuItem();
			this.mnuRecentOutgoingShipmennt = new System.Windows.Forms.MenuItem();
			this.menuItem8 = new System.Windows.Forms.MenuItem();
			this.mnuShipmentABORhConfirmation = new System.Windows.Forms.MenuItem();
			this.mnuInvoiceDiscardQuarantineRelease = new System.Windows.Forms.MenuItem();
			this.menuItem9 = new System.Windows.Forms.MenuItem();
			this.mnuEditInvoiceText = new System.Windows.Forms.MenuItem();
			this.mnuOrders = new System.Windows.Forms.MenuItem();
			this.mnuAcceptOrders = new System.Windows.Forms.MenuItem();
			this.mnuSpecimen = new System.Windows.Forms.MenuItem();
			this.mnuOrderReflexTests = new System.Windows.Forms.MenuItem();
			this.menuItem15 = new System.Windows.Forms.MenuItem();
			this.mnuOrderDataReport = new System.Windows.Forms.MenuItem();
			this.mnuRecentPatientOrders = new System.Windows.Forms.MenuItem();
			this.mnuReagents = new System.Windows.Forms.MenuItem();
			this.mnuConfigureDailyQC = new System.Windows.Forms.MenuItem();
			this.mnuEnterDailyQCResults = new System.Windows.Forms.MenuItem();
			this.mnuMaintainMinLevels = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.mnuLoginReagents = new System.Windows.Forms.MenuItem();
			this.mnuUpdateInventory = new System.Windows.Forms.MenuItem();
			this.mnuViewPrintInventory = new System.Windows.Forms.MenuItem();
			this.mnuReports = new System.Windows.Forms.MenuItem();
			this.mnuAdministrativeDataReport = new System.Windows.Forms.MenuItem();
			this.mnuAuditTrail = new System.Windows.Forms.MenuItem();
			this.mnuBloodAvailability = new System.Windows.Forms.MenuItem();
			this.mnuCostAccountingReport = new System.Windows.Forms.MenuItem();
			this.mnuCTRatioReport = new System.Windows.Forms.MenuItem();
			this.mnuDivisionTransfusionReport = new System.Windows.Forms.MenuItem();
			this.mnuDivisionWorkloadReport = new System.Windows.Forms.MenuItem();
			this.mnuExceptionReport = new System.Windows.Forms.MenuItem();
			this.mnuFinalizePrintTrw = new System.Windows.Forms.MenuItem();
			this.mnuInappropriateRequestReport = new System.Windows.Forms.MenuItem();
			this.mnuIssuedReturnedReport = new System.Windows.Forms.MenuItem();
			this.mnuMedicationProfile = new System.Windows.Forms.MenuItem();
			this.mnuOrderHistoryReport = new System.Windows.Forms.MenuItem();
			this.mnuPatientHistoryReport = new System.Windows.Forms.MenuItem();
			this.mnuProlongedTransfusionReport = new System.Windows.Forms.MenuItem();
			this.mnuTestingWorklist = new System.Windows.Forms.MenuItem();
			this.mnuTransfusionComplicationsReport = new System.Windows.Forms.MenuItem();
			this.mnuTransfusionEffectivenessReport = new System.Windows.Forms.MenuItem();
			this.mnuTransfusionReactionCountReport = new System.Windows.Forms.MenuItem();
			this.mnuTransfusionRequirementsReport = new System.Windows.Forms.MenuItem();
			this.mnuUnitHistoryReport = new System.Windows.Forms.MenuItem();
			this.mnuSupervisor = new System.Windows.Forms.MenuItem();
			this.mnuDocumentABOIncompatibleTransfusion = new System.Windows.Forms.MenuItem();
			this.mnuJustifyABORhChange = new System.Windows.Forms.MenuItem();
			this.mnuRemoveFinalUnitStatus = new System.Windows.Forms.MenuItem();
			this.mnuTools = new System.Windows.Forms.MenuItem();
			this.mnuAntibodies = new System.Windows.Forms.MenuItem();
			this.mnuBloodProducts = new System.Windows.Forms.MenuItem();
			this.mnuCannedComments = new System.Windows.Forms.MenuItem();
			this.mnuComponentClasses = new System.Windows.Forms.MenuItem();
			this.mnuEquipment = new System.Windows.Forms.MenuItem();
			this.mnuLogInEquipment = new System.Windows.Forms.MenuItem();
			this.mnuMaintainEquipment = new System.Windows.Forms.MenuItem();
			this.mnuCollectionFacilities = new System.Windows.Forms.MenuItem();
			this.mnuMSBOS = new System.Windows.Forms.MenuItem();
			this.mnuSupplies = new System.Windows.Forms.MenuItem();
			this.mnuLogInSupplies = new System.Windows.Forms.MenuItem();
			this.mnuUpdateSupplyInventory = new System.Windows.Forms.MenuItem();
			this.mnuViewPrintSupplyInventory = new System.Windows.Forms.MenuItem();
			this.mnuTransfusionComplicationns = new System.Windows.Forms.MenuItem();
			this.mnuTransfusionEffectiveness = new System.Windows.Forms.MenuItem();
			this.mnuUpdateUsers = new System.Windows.Forms.MenuItem();
			this.mnuWorkloadCodes = new System.Windows.Forms.MenuItem();
			this.mnuSplit3 = new System.Windows.Forms.MenuItem();
			this.mnuPrintBackupForms = new System.Windows.Forms.MenuItem();
			this.mnuSplit2 = new System.Windows.Forms.MenuItem();
			this.mnuConfigureDivision = new System.Windows.Forms.MenuItem();
			this.mnuHelp = new System.Windows.Forms.MenuItem();
			this.mnuVBECSHelp = new System.Windows.Forms.MenuItem();
			this.menuItem5 = new System.Windows.Forms.MenuItem();
			this.mnuAbout = new System.Windows.Forms.MenuItem();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.cmnuPatientUpdates = new System.Windows.Forms.ContextMenu();
			this.mnuUpdatedPatientsToolbar = new System.Windows.Forms.MenuItem();
			this.mnuDeceasedPatientToolbar = new System.Windows.Forms.MenuItem();
			this.mnuPatientMergeToolbar = new System.Windows.Forms.MenuItem();
			this.tbVBECS = new System.Windows.Forms.ToolBar();
			this.tbtnLoginReagents = new System.Windows.Forms.ToolBarButton();
			this.tbtnDailyQC = new System.Windows.Forms.ToolBarButton();
			this.tbtnSpacer1 = new System.Windows.Forms.ToolBarButton();
			this.tbtnIncomingShipment = new System.Windows.Forms.ToolBarButton();
			this.tbtnUnitConfirmation = new System.Windows.Forms.ToolBarButton();
			this.tbtnModifyUnits = new System.Windows.Forms.ToolBarButton();
			this.tbtnUnitTyping = new System.Windows.Forms.ToolBarButton();
			this.tbtnOutgoingShipment = new System.Windows.Forms.ToolBarButton();
			this.tbtnSpacer2 = new System.Windows.Forms.ToolBarButton();
			this.tbtnAcceptOrders = new System.Windows.Forms.ToolBarButton();
			this.tbtnMaintainSpecimen = new System.Windows.Forms.ToolBarButton();
			this.tbtnPatientTesting = new System.Windows.Forms.ToolBarButton();
			this.tbtnSelectUnits = new System.Windows.Forms.ToolBarButton();
			this.tbtnIssueUnits = new System.Windows.Forms.ToolBarButton();
			this.tbtnTransfusionInfo = new System.Windows.Forms.ToolBarButton();
			this.imgToolbar = new System.Windows.Forms.ImageList(this.components);
			this.tmrPatientAlerts = new System.Windows.Forms.Timer(this.components);
			this.tmrOrderAlerts = new System.Windows.Forms.Timer(this.components);
			this.lvOrders = new System.Windows.Forms.ListView();
			this.columnHeader7 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader9 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader6 = new System.Windows.Forms.ColumnHeader();
			this.pnlOrders = new System.Windows.Forms.Panel();
			this.btnCloseOrders = new System.Windows.Forms.Button();
			this.lblOrders = new System.Windows.Forms.Label();
			this.tmrDateTime = new System.Windows.Forms.Timer(this.components);
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelUser)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelDivision)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelTimeZone)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelOrderAlert)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelPatientAlert)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelVistALink)).BeginInit();
			this.pnlOrders.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Location = new System.Drawing.Point(1, 28);
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(791, 30);
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(1, 517);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// imglistLarge
			// 
			this.imglistLarge.ImageSize = new System.Drawing.Size(32, 32);
			this.imglistLarge.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imglistLarge.ImageStream")));
			this.imglistLarge.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// imglistSmall
			// 
			this.imglistSmall.ImageSize = new System.Drawing.Size(16, 16);
			this.imglistSmall.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imglistSmall.ImageStream")));
			this.imglistSmall.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// statusBar1
			// 
			this.statusBar1.Location = new System.Drawing.Point(1, 533);
			this.statusBar1.Name = "statusBar1";
			this.statusBar1.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
																						  this.statusBarPanelUser,
																						  this.statusBarPanelDivision,
																						  this.statusBarPanelTimeZone,
																						  this.statusBarPanelOrderAlert,
																						  this.statusBarPanelPatientAlert,
																						  this.statusBarPanelVistALink});
			this.statusBar1.ShowPanels = true;
			this.statusBar1.Size = new System.Drawing.Size(791, 20);
			this.statusBar1.TabIndex = 1;
			this.statusBar1.Text = "statusBar1";
			this.statusBar1.PanelClick += new System.Windows.Forms.StatusBarPanelClickEventHandler(this.statusBar1_PanelClick);
			// 
			// statusBarPanelUser
			// 
			this.statusBarPanelUser.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
			this.statusBarPanelUser.Icon = ((System.Drawing.Icon)(resources.GetObject("statusBarPanelUser.Icon")));
			this.statusBarPanelUser.Text = "User:";
			this.statusBarPanelUser.Width = 442;
			// 
			// statusBarPanelDivision
			// 
			this.statusBarPanelDivision.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
			this.statusBarPanelDivision.Icon = ((System.Drawing.Icon)(resources.GetObject("statusBarPanelDivision.Icon")));
			this.statusBarPanelDivision.Text = "Division:";
			this.statusBarPanelDivision.Width = 78;
			// 
			// statusBarPanelTimeZone
			// 
			this.statusBarPanelTimeZone.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
			this.statusBarPanelTimeZone.Text = "Time";
			this.statusBarPanelTimeZone.Width = 39;
			// 
			// statusBarPanelOrderAlert
			// 
			this.statusBarPanelOrderAlert.Alignment = System.Windows.Forms.HorizontalAlignment.Center;
			this.statusBarPanelOrderAlert.Icon = ((System.Drawing.Icon)(resources.GetObject("statusBarPanelOrderAlert.Icon")));
			this.statusBarPanelOrderAlert.MinWidth = 120;
			this.statusBarPanelOrderAlert.Width = 120;
			// 
			// statusBarPanelPatientAlert
			// 
			this.statusBarPanelPatientAlert.Alignment = System.Windows.Forms.HorizontalAlignment.Center;
			this.statusBarPanelPatientAlert.Icon = ((System.Drawing.Icon)(resources.GetObject("statusBarPanelPatientAlert.Icon")));
			this.statusBarPanelPatientAlert.MinWidth = 24;
			this.statusBarPanelPatientAlert.Width = 24;
			// 
			// statusBarPanelVistALink
			// 
			this.statusBarPanelVistALink.Icon = ((System.Drawing.Icon)(resources.GetObject("statusBarPanelVistALink.Icon")));
			this.statusBarPanelVistALink.MinWidth = 72;
			this.statusBarPanelVistALink.Text = "VistALink";
			this.statusBarPanelVistALink.Width = 72;
			// 
			// mnuMain
			// 
			this.mnuMain.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					this.mnuFile,
																					this.mnuEdit,
																					this.mnuBloodUnits,
																					this.mnuPatients,
																					this.mnuShipment,
																					this.mnuOrders,
																					this.mnuReagents,
																					this.mnuReports,
																					this.mnuSupervisor,
																					this.mnuTools,
																					this.mnuHelp});
			// 
			// mnuFile
			// 
			this.mnuFile.Index = 0;
			this.mnuFile.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					this.mnuChangeDivision,
																					this.mnuSplit1,
																					this.mnuExit});
			this.mnuFile.Text = "&File";
			// 
			// mnuChangeDivision
			// 
			this.mnuChangeDivision.Index = 0;
			this.mnuChangeDivision.Text = "Change &Division";
			this.mnuChangeDivision.Click += new System.EventHandler(this.mnuChangeDivision_Click);
			// 
			// mnuSplit1
			// 
			this.mnuSplit1.Index = 1;
			this.mnuSplit1.Text = "-";
			// 
			// mnuExit
			// 
			this.mnuExit.Index = 2;
			this.mnuExit.Shortcut = System.Windows.Forms.Shortcut.AltF4;
			this.mnuExit.Text = "E&xit VBECS";
			this.mnuExit.Click += new System.EventHandler(this.mnuExit_Click);
			// 
			// mnuEdit
			// 
			this.mnuEdit.Index = 1;
			this.mnuEdit.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					this.mnuUndo,
																					this.mnuSplit4,
																					this.mnuCut,
																					this.mnuCopy,
																					this.mnuPaste,
																					this.mnuDelete,
																					this.mnuSplit5,
																					this.mnuSelectAll});
			this.mnuEdit.Text = "&Edit";
			this.mnuEdit.Popup += new System.EventHandler(this.mnuEdit_Popup);
			// 
			// mnuUndo
			// 
			this.mnuUndo.Index = 0;
			this.mnuUndo.Shortcut = System.Windows.Forms.Shortcut.CtrlU;
			this.mnuUndo.Text = "&Undo";
			this.mnuUndo.Click += new System.EventHandler(this.mnuUndo_Click);
			// 
			// mnuSplit4
			// 
			this.mnuSplit4.Index = 1;
			this.mnuSplit4.Text = "-";
			// 
			// mnuCut
			// 
			this.mnuCut.Index = 2;
			this.mnuCut.Shortcut = System.Windows.Forms.Shortcut.CtrlX;
			this.mnuCut.Text = "Cu&t";
			this.mnuCut.Click += new System.EventHandler(this.mnuCut_Click);
			// 
			// mnuCopy
			// 
			this.mnuCopy.Index = 3;
			this.mnuCopy.Shortcut = System.Windows.Forms.Shortcut.CtrlC;
			this.mnuCopy.Text = "&Copy";
			this.mnuCopy.Click += new System.EventHandler(this.mnuCopy_Click);
			// 
			// mnuPaste
			// 
			this.mnuPaste.Index = 4;
			this.mnuPaste.Shortcut = System.Windows.Forms.Shortcut.CtrlV;
			this.mnuPaste.Text = "&Paste";
			this.mnuPaste.Click += new System.EventHandler(this.mnuPaste_Click);
			// 
			// mnuDelete
			// 
			this.mnuDelete.Index = 5;
			this.mnuDelete.Shortcut = System.Windows.Forms.Shortcut.Del;
			this.mnuDelete.Text = "&Delete";
			this.mnuDelete.Click += new System.EventHandler(this.mnuDelete_Click);
			// 
			// mnuSplit5
			// 
			this.mnuSplit5.Index = 6;
			this.mnuSplit5.Text = "-";
			// 
			// mnuSelectAll
			// 
			this.mnuSelectAll.Index = 7;
			this.mnuSelectAll.Shortcut = System.Windows.Forms.Shortcut.CtrlA;
			this.mnuSelectAll.Text = "Select A&ll";
			this.mnuSelectAll.Click += new System.EventHandler(this.mnuSelectAll_Click);
			// 
			// mnuBloodUnits
			// 
			this.mnuBloodUnits.Index = 2;
			this.mnuBloodUnits.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						  this.mnuGenerateLabel,
																						  this.mnuPrintTagFormUnit,
																						  this.menuItem7,
																						  this.mnuABORhConfirmation,
																						  this.mnuUnitAntigenTyping,
																						  this.mnuModifyUnits,
																						  this.mnuSelectUnits,
																						  this.menuItem6,
																						  this.mnuDiscardQuarantineRelease,
																						  this.mnuFreeDirectedUnit,
																						  this.mnuReleaseUnitsFromPatientAssignment,
																						  this.mnuReturnIssuedUnits,
																						  this.menuItem1,
																						  this.mnuEditFinancialData,
																						  this.mnuEditUnitInformation,
																						  this.mnuBloodUnitDataReport});
			this.mnuBloodUnits.Text = "&Blood Units";
			// 
			// mnuGenerateLabel
			// 
			this.mnuGenerateLabel.Enabled = false;
			this.mnuGenerateLabel.Index = 0;
			this.mnuGenerateLabel.Text = "Generate Full Face &Label";
			this.mnuGenerateLabel.Click += new System.EventHandler(this.mnuGenerateLabel_Click);
			// 
			// mnuPrintTagFormUnit
			// 
			this.mnuPrintTagFormUnit.Index = 1;
			this.mnuPrintTagFormUnit.Text = "&Print Unit Caution Tag && Transfusion Record Form";
			this.mnuPrintTagFormUnit.Click += new System.EventHandler(this.mnuPrintTagFormUnit_Click);
			// 
			// menuItem7
			// 
			this.menuItem7.Index = 2;
			this.menuItem7.Text = "-";
			// 
			// mnuABORhConfirmation
			// 
			this.mnuABORhConfirmation.Index = 3;
			this.mnuABORhConfirmation.Text = "&ABO/Rh Confirmation";
			this.mnuABORhConfirmation.Click += new System.EventHandler(this.mnuABORhConfirmation_Click);
			// 
			// mnuUnitAntigenTyping
			// 
			this.mnuUnitAntigenTyping.Index = 4;
			this.mnuUnitAntigenTyping.Text = "Unit Antigen &Typing";
			this.mnuUnitAntigenTyping.Click += new System.EventHandler(this.mnuUnitAntigenTyping_Click);
			// 
			// mnuModifyUnits
			// 
			this.mnuModifyUnits.Index = 5;
			this.mnuModifyUnits.Text = "&Modify Units";
			this.mnuModifyUnits.Click += new System.EventHandler(this.mnuModifyUnits_Click);
			// 
			// mnuSelectUnits
			// 
			this.mnuSelectUnits.Index = 6;
			this.mnuSelectUnits.Text = "&Select Units";
			this.mnuSelectUnits.Click += new System.EventHandler(this.mnuSelectUnits_Click);
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 7;
			this.menuItem6.Text = "-";
			// 
			// mnuDiscardQuarantineRelease
			// 
			this.mnuDiscardQuarantineRelease.Index = 8;
			this.mnuDiscardQuarantineRelease.Text = "&Discard or Quarantine";
			this.mnuDiscardQuarantineRelease.Click += new System.EventHandler(this.mnuDiscardQuarantineRelease_Click);
			// 
			// mnuFreeDirectedUnit
			// 
			this.mnuFreeDirectedUnit.Index = 9;
			this.mnuFreeDirectedUnit.Text = "Free Directed Unit For &Crossover";
			this.mnuFreeDirectedUnit.Click += new System.EventHandler(this.mnuFreeDirectedUnit_Click);
			// 
			// mnuReleaseUnitsFromPatientAssignment
			// 
			this.mnuReleaseUnitsFromPatientAssignment.Index = 10;
			this.mnuReleaseUnitsFromPatientAssignment.Text = "&Release Units From Patient Assignment";
			this.mnuReleaseUnitsFromPatientAssignment.Click += new System.EventHandler(this.mnuReleaseUnitsFromAssignment_Click);
			// 
			// mnuReturnIssuedUnits
			// 
			this.mnuReturnIssuedUnits.Index = 11;
			this.mnuReturnIssuedUnits.Text = "R&eturn Issued Units To Blood Bank";
			this.mnuReturnIssuedUnits.Click += new System.EventHandler(this.mnuReturnIssuedUnits_Click);
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 12;
			this.menuItem1.Text = "-";
			// 
			// mnuEditFinancialData
			// 
			this.mnuEditFinancialData.Index = 13;
			this.mnuEditFinancialData.Text = "Edit &Financial Data";
			this.mnuEditFinancialData.Click += new System.EventHandler(this.mnuEditFinancialData_Click);
			// 
			// mnuEditUnitInformation
			// 
			this.mnuEditUnitInformation.Index = 14;
			this.mnuEditUnitInformation.Text = "Edit Unit &Information";
			this.mnuEditUnitInformation.Click += new System.EventHandler(this.mnuEditUnitInformation_Click);
			// 
			// mnuBloodUnitDataReport
			// 
			this.mnuBloodUnitDataReport.Index = 15;
			this.mnuBloodUnitDataReport.Text = "&Unit History Report";
			this.mnuBloodUnitDataReport.Click += new System.EventHandler(this.mnuUnitHistoryReport_Click);
			// 
			// mnuPatients
			// 
			this.mnuPatients.Index = 3;
			this.mnuPatients.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						this.mnuRecentOrders,
																						this.mnuPatientBloodAvailability,
																						this.mnuRecentTransfusionIssues,
																						this.menuItem11,
																						this.mnuPatientTesting,
																						this.mnuPatientTestingWorklist,
																						this.mnuPrintTagFormPatient,
																						this.mnuIssueBlood,
																						this.mnuPostTransfusionDetails,
																						this.menuItem2,
																						this.mnuReleaseUnitsFromAssignment,
																						this.mnuReturnIssuedUnitsForPatient,
																						this.mnuInvalidatePatientTesting,
																						this.menuItem3,
																						this.mnuSIAndTRs,
																						this.mnuTransfusionReactionHistory,
																						this.menuItem10,
																						this.mnuPatientRecordReport,
																						this.mnuPatientUpdates});
			this.mnuPatients.Text = "&Patients";
			// 
			// mnuRecentOrders
			// 
			this.mnuRecentOrders.Index = 0;
			this.mnuRecentOrders.Text = "Recent &Orders";
			this.mnuRecentOrders.Click += new System.EventHandler(this.mnuRecentOrders_Click);
			// 
			// mnuPatientBloodAvailability
			// 
			this.mnuPatientBloodAvailability.Index = 1;
			this.mnuPatientBloodAvailability.Text = "&Blood Availability";
			this.mnuPatientBloodAvailability.Click += new System.EventHandler(this.mnuPatientBloodAvailability_Click);
			// 
			// mnuRecentTransfusionIssues
			// 
			this.mnuRecentTransfusionIssues.Index = 2;
			this.mnuRecentTransfusionIssues.Text = "R&ecent Transfusions/Issued Units";
			this.mnuRecentTransfusionIssues.Click += new System.EventHandler(this.mnuRecentTransfusionIssues_Click);
			// 
			// menuItem11
			// 
			this.menuItem11.Index = 3;
			this.menuItem11.Text = "-";
			// 
			// mnuPatientTesting
			// 
			this.mnuPatientTesting.Index = 4;
			this.mnuPatientTesting.Text = "&Patient Testing";
			this.mnuPatientTesting.Click += new System.EventHandler(this.mnuPatientTesting_Click);
			// 
			// mnuPatientTestingWorklist
			// 
			this.mnuPatientTestingWorklist.Index = 5;
			this.mnuPatientTestingWorklist.Text = "Patient Testing &Worklist Report";
			this.mnuPatientTestingWorklist.Click += new System.EventHandler(this.mnuPatientTestingWorklist_Click);
			// 
			// mnuPrintTagFormPatient
			// 
			this.mnuPrintTagFormPatient.Index = 6;
			this.mnuPrintTagFormPatient.Text = "Print &Unit Caution Tag && Transfusion Record Form";
			this.mnuPrintTagFormPatient.Click += new System.EventHandler(this.mnuPrintTagFormPatient_Click);
			// 
			// mnuIssueBlood
			// 
			this.mnuIssueBlood.Index = 7;
			this.mnuIssueBlood.Text = "&Issue Blood Components";
			this.mnuIssueBlood.Click += new System.EventHandler(this.mnuIssueBlood_Click);
			// 
			// mnuPostTransfusionDetails
			// 
			this.mnuPostTransfusionDetails.Index = 8;
			this.mnuPostTransfusionDetails.Text = "Post-&Transfusion Information";
			this.mnuPostTransfusionDetails.Click += new System.EventHandler(this.mnuPostTransfusionDetails_Click);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 9;
			this.menuItem2.Text = "-";
			// 
			// mnuReleaseUnitsFromAssignment
			// 
			this.mnuReleaseUnitsFromAssignment.Index = 10;
			this.mnuReleaseUnitsFromAssignment.Text = "&Release Units From Patient Assignment";
			this.mnuReleaseUnitsFromAssignment.Click += new System.EventHandler(this.mnuReleaseUnitsFromAssignment_Click);
			// 
			// mnuReturnIssuedUnitsForPatient
			// 
			this.mnuReturnIssuedUnitsForPatient.Index = 11;
			this.mnuReturnIssuedUnitsForPatient.Text = "Return Issued Units To Blood Ban&k";
			this.mnuReturnIssuedUnitsForPatient.Click += new System.EventHandler(this.mnuReturnIssuedUnitsForPatient_Click);
			// 
			// mnuInvalidatePatientTesting
			// 
			this.mnuInvalidatePatientTesting.Index = 12;
			this.mnuInvalidatePatientTesting.Text = "In&validate Test Results";
			this.mnuInvalidatePatientTesting.Click += new System.EventHandler(this.mnuInvalidatePatientTesting_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 13;
			this.menuItem3.Text = "-";
			// 
			// mnuSIAndTRs
			// 
			this.mnuSIAndTRs.Index = 14;
			this.mnuSIAndTRs.Text = "&Special Instructions && Transfusion Requirements";
			this.mnuSIAndTRs.Click += new System.EventHandler(this.mnuSIAndTRs_Click);
			// 
			// mnuTransfusionReactionHistory
			// 
			this.mnuTransfusionReactionHistory.Index = 15;
			this.mnuTransfusionReactionHistory.Text = "Tr&ansfusion Reaction History";
			this.mnuTransfusionReactionHistory.Click += new System.EventHandler(this.mnuTransfusionReactionHistory_Click);
			// 
			// menuItem10
			// 
			this.menuItem10.Index = 16;
			this.menuItem10.Text = "-";
			// 
			// mnuPatientRecordReport
			// 
			this.mnuPatientRecordReport.Index = 17;
			this.mnuPatientRecordReport.Text = "Patient &History Report";
			this.mnuPatientRecordReport.Click += new System.EventHandler(this.mnuPatientHistoryReport_Click);
			// 
			// mnuPatientUpdates
			// 
			this.mnuPatientUpdates.Index = 18;
			this.mnuPatientUpdates.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																							  this.mnuPatientMerge,
																							  this.mnuUpdatedPatients,
																							  this.mnnuDeceasedPatients});
			this.mnuPatientUpdates.Text = "Patient U&pdates";
			// 
			// mnuPatientMerge
			// 
			this.mnuPatientMerge.Index = 0;
			this.mnuPatientMerge.Text = "Patient &Merge";
			this.mnuPatientMerge.Click += new System.EventHandler(this.mnuPatientMerge_Click);
			// 
			// mnuUpdatedPatients
			// 
			this.mnuUpdatedPatients.Index = 1;
			this.mnuUpdatedPatients.Text = "&Updated Patients";
			this.mnuUpdatedPatients.Click += new System.EventHandler(this.mnuUpdatedPatients_Click);
			// 
			// mnnuDeceasedPatients
			// 
			this.mnnuDeceasedPatients.Index = 2;
			this.mnnuDeceasedPatients.Text = "&Deceased Patients";
			this.mnnuDeceasedPatients.Click += new System.EventHandler(this.mnnuDeceasedPatients_Click);
			// 
			// mnuShipment
			// 
			this.mnuShipment.Index = 4;
			this.mnuShipment.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						this.mnuIncomingShipment,
																						this.mnuOutgoingShipment,
																						this.menuItem8,
																						this.mnuShipmentABORhConfirmation,
																						this.mnuInvoiceDiscardQuarantineRelease,
																						this.menuItem9,
																						this.mnuEditInvoiceText});
			this.mnuShipment.Text = "&Shipments";
			// 
			// mnuIncomingShipment
			// 
			this.mnuIncomingShipment.Index = 0;
			this.mnuIncomingShipment.Text = "&Incoming Shipment";
			this.mnuIncomingShipment.Click += new System.EventHandler(this.mnuIncomingShipment_Click);
			// 
			// mnuOutgoingShipment
			// 
			this.mnuOutgoingShipment.Index = 1;
			this.mnuOutgoingShipment.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																								this.mnuNewOutgoingShipment,
																								this.mnuRecentOutgoingShipmennt});
			this.mnuOutgoingShipment.Text = "&Outgoing Shipment";
			// 
			// mnuNewOutgoingShipment
			// 
			this.mnuNewOutgoingShipment.Index = 0;
			this.mnuNewOutgoingShipment.Text = "&New Invoice";
			this.mnuNewOutgoingShipment.Click += new System.EventHandler(this.mnuNewOutgoingShipment_Click);
			// 
			// mnuRecentOutgoingShipmennt
			// 
			this.mnuRecentOutgoingShipmennt.Index = 1;
			this.mnuRecentOutgoingShipmennt.Text = "&Recent Invoice";
			this.mnuRecentOutgoingShipmennt.Click += new System.EventHandler(this.mnuRecentOutgoingShipmennt_Click);
			// 
			// menuItem8
			// 
			this.menuItem8.Index = 2;
			this.menuItem8.Text = "-";
			// 
			// mnuShipmentABORhConfirmation
			// 
			this.mnuShipmentABORhConfirmation.Index = 3;
			this.mnuShipmentABORhConfirmation.Text = "&ABO/Rh Confirmation";
			this.mnuShipmentABORhConfirmation.Click += new System.EventHandler(this.mnuShipmentABORhConfirmation_Click);
			// 
			// mnuInvoiceDiscardQuarantineRelease
			// 
			this.mnuInvoiceDiscardQuarantineRelease.Index = 4;
			this.mnuInvoiceDiscardQuarantineRelease.Text = "&Discard or Quarantine";
			this.mnuInvoiceDiscardQuarantineRelease.Click += new System.EventHandler(this.mnuInvoiceDiscardQuarantineRelease_Click);
			// 
			// menuItem9
			// 
			this.menuItem9.Index = 5;
			this.menuItem9.Text = "-";
			// 
			// mnuEditInvoiceText
			// 
			this.mnuEditInvoiceText.Index = 6;
			this.mnuEditInvoiceText.Text = "&Edit Invoice Text";
			this.mnuEditInvoiceText.Click += new System.EventHandler(this.mnuEditInvoiceText_Click);
			// 
			// mnuOrders
			// 
			this.mnuOrders.Index = 5;
			this.mnuOrders.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.mnuAcceptOrders,
																					  this.mnuSpecimen,
																					  this.mnuOrderReflexTests,
																					  this.menuItem15,
																					  this.mnuOrderDataReport,
																					  this.mnuRecentPatientOrders});
			this.mnuOrders.Text = "&Orders";
			// 
			// mnuAcceptOrders
			// 
			this.mnuAcceptOrders.Index = 0;
			this.mnuAcceptOrders.Text = "&Accept Orders";
			this.mnuAcceptOrders.Click += new System.EventHandler(this.mnuAcceptOrders_Click);
			// 
			// mnuSpecimen
			// 
			this.mnuSpecimen.Index = 1;
			this.mnuSpecimen.Text = "Maintain &Specimen";
			this.mnuSpecimen.Click += new System.EventHandler(this.mnuSpecimen_Click);
			// 
			// mnuOrderReflexTests
			// 
			this.mnuOrderReflexTests.Index = 2;
			this.mnuOrderReflexTests.Text = "Order &Reflex Tests";
			this.mnuOrderReflexTests.Click += new System.EventHandler(this.mnuOrderReflexTests_Click);
			// 
			// menuItem15
			// 
			this.menuItem15.Index = 3;
			this.menuItem15.Text = "-";
			// 
			// mnuOrderDataReport
			// 
			this.mnuOrderDataReport.Index = 4;
			this.mnuOrderDataReport.Text = "Order History Report";
			this.mnuOrderDataReport.Click += new System.EventHandler(this.mnuOrderDataReport_Click);
			// 
			// mnuRecentPatientOrders
			// 
			this.mnuRecentPatientOrders.Index = 5;
			this.mnuRecentPatientOrders.Text = "Recent &Patient Orders";
			this.mnuRecentPatientOrders.Click += new System.EventHandler(this.mnuRecentOrders_Click);
			// 
			// mnuReagents
			// 
			this.mnuReagents.Index = 6;
			this.mnuReagents.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						this.mnuConfigureDailyQC,
																						this.mnuEnterDailyQCResults,
																						this.mnuMaintainMinLevels,
																						this.menuItem4,
																						this.mnuLoginReagents,
																						this.mnuUpdateInventory,
																						this.mnuViewPrintInventory});
			this.mnuReagents.Text = "Re&agents";
			// 
			// mnuConfigureDailyQC
			// 
			this.mnuConfigureDailyQC.Index = 0;
			this.mnuConfigureDailyQC.Text = "&Configure Daily QC";
			this.mnuConfigureDailyQC.Click += new System.EventHandler(this.mnuConfigureDailyQC_Click);
			// 
			// mnuEnterDailyQCResults
			// 
			this.mnuEnterDailyQCResults.Index = 1;
			this.mnuEnterDailyQCResults.Text = "Enter &Daily QC Results";
			this.mnuEnterDailyQCResults.Click += new System.EventHandler(this.mnuEnterDailyQCResults_Click);
			// 
			// mnuMaintainMinLevels
			// 
			this.mnuMaintainMinLevels.Index = 2;
			this.mnuMaintainMinLevels.Text = "&Maintain Minimum Levels";
			this.mnuMaintainMinLevels.Click += new System.EventHandler(this.mnuMaintainMinLevels_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 3;
			this.menuItem4.Text = "-";
			// 
			// mnuLoginReagents
			// 
			this.mnuLoginReagents.Index = 4;
			this.mnuLoginReagents.Text = "&Log In Reagents";
			this.mnuLoginReagents.Click += new System.EventHandler(this.mnuLoginReagents_Click);
			// 
			// mnuUpdateInventory
			// 
			this.mnuUpdateInventory.Index = 5;
			this.mnuUpdateInventory.Text = "&Update Inventory";
			this.mnuUpdateInventory.Click += new System.EventHandler(this.mnuUpdateInventory_Click);
			// 
			// mnuViewPrintInventory
			// 
			this.mnuViewPrintInventory.Index = 6;
			this.mnuViewPrintInventory.Text = "&View/Print Inventory";
			this.mnuViewPrintInventory.Click += new System.EventHandler(this.mnuViewPrintInventory_Click);
			// 
			// mnuReports
			// 
			this.mnuReports.Index = 7;
			this.mnuReports.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					   this.mnuAdministrativeDataReport,
																					   this.mnuAuditTrail,
																					   this.mnuBloodAvailability,
																					   this.mnuCostAccountingReport,
																					   this.mnuCTRatioReport,
																					   this.mnuDivisionTransfusionReport,
																					   this.mnuDivisionWorkloadReport,
																					   this.mnuExceptionReport,
																					   this.mnuFinalizePrintTrw,
																					   this.mnuInappropriateRequestReport,
																					   this.mnuIssuedReturnedReport,
																					   this.mnuMedicationProfile,
																					   this.mnuOrderHistoryReport,
																					   this.mnuPatientHistoryReport,
																					   this.mnuProlongedTransfusionReport,
																					   this.mnuTestingWorklist,
																					   this.mnuTransfusionComplicationsReport,
																					   this.mnuTransfusionEffectivenessReport,
																					   this.mnuTransfusionReactionCountReport,
																					   this.mnuTransfusionRequirementsReport,
																					   this.mnuUnitHistoryReport});
			this.mnuReports.Text = "&Reports";
			// 
			// mnuAdministrativeDataReport
			// 
			this.mnuAdministrativeDataReport.Index = 0;
			this.mnuAdministrativeDataReport.Text = "Admini&strative Data Report";
			this.mnuAdministrativeDataReport.Click += new System.EventHandler(this.mnuAdministrativeDataReport_Click);
			// 
			// mnuAuditTrail
			// 
			this.mnuAuditTrail.Index = 1;
			this.mnuAuditTrail.Text = "&Audit Trail";
			this.mnuAuditTrail.Click += new System.EventHandler(this.mnuAuditTrail_Click);
			// 
			// mnuBloodAvailability
			// 
			this.mnuBloodAvailability.Index = 2;
			this.mnuBloodAvailability.Text = "&Blood Availability";
			this.mnuBloodAvailability.Click += new System.EventHandler(this.mnuBloodAvailability_Click);
			// 
			// mnuCostAccountingReport
			// 
			this.mnuCostAccountingReport.Index = 3;
			this.mnuCostAccountingReport.Text = "C&ost Accounting Report";
			this.mnuCostAccountingReport.Click += new System.EventHandler(this.mnuCostAccountingReport_Click);
			// 
			// mnuCTRatioReport
			// 
			this.mnuCTRatioReport.Index = 4;
			this.mnuCTRatioReport.Text = "&C:T Ratio Report";
			this.mnuCTRatioReport.Click += new System.EventHandler(this.mnuCTRatioReport_Click);
			// 
			// mnuDivisionTransfusionReport
			// 
			this.mnuDivisionTransfusionReport.Index = 5;
			this.mnuDivisionTransfusionReport.Text = "&Division Transfusion Report";
			this.mnuDivisionTransfusionReport.Click += new System.EventHandler(this.mnuDivisionTransfusionReport_Click);
			// 
			// mnuDivisionWorkloadReport
			// 
			this.mnuDivisionWorkloadReport.Index = 6;
			this.mnuDivisionWorkloadReport.Text = "Di&vision Workload Report";
			this.mnuDivisionWorkloadReport.Click += new System.EventHandler(this.mnuDivisionWorkloadReport_Click);
			// 
			// mnuExceptionReport
			// 
			this.mnuExceptionReport.Index = 7;
			this.mnuExceptionReport.Text = "E&xception Report";
			this.mnuExceptionReport.Click += new System.EventHandler(this.mnuExceptionReport_Click);
			// 
			// mnuFinalizePrintTrw
			// 
			this.mnuFinalizePrintTrw.Index = 8;
			this.mnuFinalizePrintTrw.Text = "&Finalize/Print TRW";
			this.mnuFinalizePrintTrw.Click += new System.EventHandler(this.mnuFinalizePrintTrw_Click);
			// 
			// mnuInappropriateRequestReport
			// 
			this.mnuInappropriateRequestReport.Index = 9;
			this.mnuInappropriateRequestReport.Text = "I&nappropriate Transfusion Request Report";
			this.mnuInappropriateRequestReport.Click += new System.EventHandler(this.mnuInappropriateRequestReport_Click);
			// 
			// mnuIssuedReturnedReport
			// 
			this.mnuIssuedReturnedReport.Index = 10;
			this.mnuIssuedReturnedReport.Text = "&Issued/Returned Report";
			this.mnuIssuedReturnedReport.Click += new System.EventHandler(this.mnuIssuedReturnedReport_Click);
			// 
			// mnuMedicationProfile
			// 
			this.mnuMedicationProfile.Index = 11;
			this.mnuMedicationProfile.Text = "&Medication Profile";
			this.mnuMedicationProfile.Click += new System.EventHandler(this.mnuMedicationProfile_Click);
			// 
			// mnuOrderHistoryReport
			// 
			this.mnuOrderHistoryReport.Index = 12;
			this.mnuOrderHistoryReport.Text = "Order Histor&y Report";
			this.mnuOrderHistoryReport.Click += new System.EventHandler(this.mnuOrderHistoryReport_Click);
			// 
			// mnuPatientHistoryReport
			// 
			this.mnuPatientHistoryReport.Index = 13;
			this.mnuPatientHistoryReport.Text = "Patient &History Report";
			this.mnuPatientHistoryReport.Click += new System.EventHandler(this.mnuPatientHistoryReport_Click);
			// 
			// mnuProlongedTransfusionReport
			// 
			this.mnuProlongedTransfusionReport.Index = 14;
			this.mnuProlongedTransfusionReport.Text = "&Prolonged Transfusion Time Report";
			this.mnuProlongedTransfusionReport.Click += new System.EventHandler(this.mnuProlongedTransfusionReport_Click);
			// 
			// mnuTestingWorklist
			// 
			this.mnuTestingWorklist.Index = 15;
			this.mnuTestingWorklist.Text = "Testing &Worklist Report";
			this.mnuTestingWorklist.Click += new System.EventHandler(this.mnuTestingWorklist_Click);
			// 
			// mnuTransfusionComplicationsReport
			// 
			this.mnuTransfusionComplicationsReport.Index = 16;
			this.mnuTransfusionComplicationsReport.Text = "&Transfusion Complications Report";
			this.mnuTransfusionComplicationsReport.Click += new System.EventHandler(this.mnuTransfusionComplicationsReport_Click);
			// 
			// mnuTransfusionEffectivenessReport
			// 
			this.mnuTransfusionEffectivenessReport.Index = 17;
			this.mnuTransfusionEffectivenessReport.Text = "Transfusion &Effectiveness Report";
			this.mnuTransfusionEffectivenessReport.Click += new System.EventHandler(this.mnuTransfusionEffectivenessReport_Click);
			// 
			// mnuTransfusionReactionCountReport
			// 
			this.mnuTransfusionReactionCountReport.Index = 18;
			this.mnuTransfusionReactionCountReport.Text = "Transfusion &Reaction Count Report";
			this.mnuTransfusionReactionCountReport.Click += new System.EventHandler(this.mnuTransfusionReactionCountReport_Click);
			// 
			// mnuTransfusionRequirementsReport
			// 
			this.mnuTransfusionRequirementsReport.Index = 19;
			this.mnuTransfusionRequirementsReport.Text = "Transfusion Re&quirements Report";
			this.mnuTransfusionRequirementsReport.Click += new System.EventHandler(this.mnuTransfusionRequirementsReport_Click);
			// 
			// mnuUnitHistoryReport
			// 
			this.mnuUnitHistoryReport.Index = 20;
			this.mnuUnitHistoryReport.Text = "&Unit History Report";
			this.mnuUnitHistoryReport.Click += new System.EventHandler(this.mnuUnitHistoryReport_Click);
			// 
			// mnuSupervisor
			// 
			this.mnuSupervisor.Index = 8;
			this.mnuSupervisor.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						  this.mnuDocumentABOIncompatibleTransfusion,
																						  this.mnuJustifyABORhChange,
																						  this.mnuRemoveFinalUnitStatus});
			this.mnuSupervisor.Text = "Super&visor";
			// 
			// mnuDocumentABOIncompatibleTransfusion
			// 
			this.mnuDocumentABOIncompatibleTransfusion.Index = 0;
			this.mnuDocumentABOIncompatibleTransfusion.Text = "Document ABO Incompatible &Transfusion";
			this.mnuDocumentABOIncompatibleTransfusion.Click += new System.EventHandler(this.mnuDocumentABOIncompatibleTransfusion_Click);
			// 
			// mnuJustifyABORhChange
			// 
			this.mnuJustifyABORhChange.Index = 1;
			this.mnuJustifyABORhChange.Text = "&Justify ABO/Rh Change";
			this.mnuJustifyABORhChange.Click += new System.EventHandler(this.mnuJustifyABORhChange_Click);
			// 
			// mnuRemoveFinalUnitStatus
			// 
			this.mnuRemoveFinalUnitStatus.Index = 2;
			this.mnuRemoveFinalUnitStatus.Text = "Remove Final &Status";
			this.mnuRemoveFinalUnitStatus.Click += new System.EventHandler(this.mnuRemoveFinalUnitStatus_Click);
			// 
			// mnuTools
			// 
			this.mnuTools.Index = 9;
			this.mnuTools.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.mnuAntibodies,
																					 this.mnuBloodProducts,
																					 this.mnuCannedComments,
																					 this.mnuComponentClasses,
																					 this.mnuEquipment,
																					 this.mnuCollectionFacilities,
																					 this.mnuMSBOS,
																					 this.mnuSupplies,
																					 this.mnuTransfusionComplicationns,
																					 this.mnuTransfusionEffectiveness,
																					 this.mnuUpdateUsers,
																					 this.mnuWorkloadCodes,
																					 this.mnuSplit3,
																					 this.mnuPrintBackupForms,
																					 this.mnuSplit2,
																					 this.mnuConfigureDivision});
			this.mnuTools.Text = "&Tools";
			// 
			// mnuAntibodies
			// 
			this.mnuAntibodies.Index = 0;
			this.mnuAntibodies.Text = "&Antibodies";
			this.mnuAntibodies.Click += new System.EventHandler(this.mnuAntibodies_Click);
			// 
			// mnuBloodProducts
			// 
			this.mnuBloodProducts.Index = 1;
			this.mnuBloodProducts.Text = "&Blood Products";
			this.mnuBloodProducts.Click += new System.EventHandler(this.mnuBloodProducts_Click);
			// 
			// mnuCannedComments
			// 
			this.mnuCannedComments.Index = 2;
			this.mnuCannedComments.Text = "&Canned Comments";
			this.mnuCannedComments.Click += new System.EventHandler(this.mnuCannedComments_Click);
			// 
			// mnuComponentClasses
			// 
			this.mnuComponentClasses.Index = 3;
			this.mnuComponentClasses.Text = "Component C&lasses";
			this.mnuComponentClasses.Click += new System.EventHandler(this.mnuComponentClasses_Click);
			// 
			// mnuEquipment
			// 
			this.mnuEquipment.Index = 4;
			this.mnuEquipment.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this.mnuLogInEquipment,
																						 this.mnuMaintainEquipment});
			this.mnuEquipment.Text = "E&quipment";
			// 
			// mnuLogInEquipment
			// 
			this.mnuLogInEquipment.Index = 0;
			this.mnuLogInEquipment.Text = "&Log In Equipment";
			this.mnuLogInEquipment.Click += new System.EventHandler(this.mnuLogInEquipment_Click);
			// 
			// mnuMaintainEquipment
			// 
			this.mnuMaintainEquipment.Index = 1;
			this.mnuMaintainEquipment.Text = "&Maintain Equipment";
			this.mnuMaintainEquipment.Click += new System.EventHandler(this.mnuMaintainEquipment_Click);
			// 
			// mnuCollectionFacilities
			// 
			this.mnuCollectionFacilities.Index = 5;
			this.mnuCollectionFacilities.Text = "Local &Facilities";
			this.mnuCollectionFacilities.Click += new System.EventHandler(this.mnuCollectionFacilities_Click);
			// 
			// mnuMSBOS
			// 
			this.mnuMSBOS.Index = 6;
			this.mnuMSBOS.Text = "&MSBOS";
			this.mnuMSBOS.Click += new System.EventHandler(this.mnuMSBOS_Click);
			// 
			// mnuSupplies
			// 
			this.mnuSupplies.Index = 7;
			this.mnuSupplies.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						this.mnuLogInSupplies,
																						this.mnuUpdateSupplyInventory,
																						this.mnuViewPrintSupplyInventory});
			this.mnuSupplies.Text = "&Supplies";
			// 
			// mnuLogInSupplies
			// 
			this.mnuLogInSupplies.Index = 0;
			this.mnuLogInSupplies.Text = "&Log In Supplies";
			this.mnuLogInSupplies.Click += new System.EventHandler(this.mnuLogInSupplies_Click);
			// 
			// mnuUpdateSupplyInventory
			// 
			this.mnuUpdateSupplyInventory.Index = 1;
			this.mnuUpdateSupplyInventory.Text = "&Update Supply Inventory";
			this.mnuUpdateSupplyInventory.Click += new System.EventHandler(this.mnuUpdateSupplyInventory_Click);
			// 
			// mnuViewPrintSupplyInventory
			// 
			this.mnuViewPrintSupplyInventory.Index = 2;
			this.mnuViewPrintSupplyInventory.Text = "&View/Print Supply Inventory";
			this.mnuViewPrintSupplyInventory.Click += new System.EventHandler(this.mnuViewPrintSupplyInventory_Click);
			// 
			// mnuTransfusionComplicationns
			// 
			this.mnuTransfusionComplicationns.Index = 8;
			this.mnuTransfusionComplicationns.Text = "&Transfusion Complications";
			this.mnuTransfusionComplicationns.Click += new System.EventHandler(this.mnuTransfusionComplicationns_Click);
			// 
			// mnuTransfusionEffectiveness
			// 
			this.mnuTransfusionEffectiveness.Index = 9;
			this.mnuTransfusionEffectiveness.Text = "Transfusion &Effectiveness";
			this.mnuTransfusionEffectiveness.Click += new System.EventHandler(this.mnuTransfusionEffectiveness_Click);
			// 
			// mnuUpdateUsers
			// 
			this.mnuUpdateUsers.Index = 10;
			this.mnuUpdateUsers.Text = "Update &User Roles";
			this.mnuUpdateUsers.Click += new System.EventHandler(this.mnuUpdateUsers_Click);
			// 
			// mnuWorkloadCodes
			// 
			this.mnuWorkloadCodes.Index = 11;
			this.mnuWorkloadCodes.Text = "&Workload Codes";
			this.mnuWorkloadCodes.Click += new System.EventHandler(this.mnuWorkloadCodes_Click);
			// 
			// mnuSplit3
			// 
			this.mnuSplit3.Index = 12;
			this.mnuSplit3.Text = "-";
			// 
			// mnuPrintBackupForms
			// 
			this.mnuPrintBackupForms.Index = 13;
			this.mnuPrintBackupForms.Text = "&Print Backup Forms";
			this.mnuPrintBackupForms.Click += new System.EventHandler(this.mnuPrintBackupForms_Click);
			// 
			// mnuSplit2
			// 
			this.mnuSplit2.Index = 14;
			this.mnuSplit2.Text = "-";
			// 
			// mnuConfigureDivision
			// 
			this.mnuConfigureDivision.Index = 15;
			this.mnuConfigureDivision.Text = "Configure &Division";
			this.mnuConfigureDivision.Click += new System.EventHandler(this.mnuConfigureDivision_Click);
			// 
			// mnuHelp
			// 
			this.mnuHelp.Index = 10;
			this.mnuHelp.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					this.mnuVBECSHelp,
																					this.menuItem5,
																					this.mnuAbout});
			this.mnuHelp.Text = "&Help";
			// 
			// mnuVBECSHelp
			// 
			this.mnuVBECSHelp.Index = 0;
			this.mnuVBECSHelp.Shortcut = System.Windows.Forms.Shortcut.CtrlF1;
			this.mnuVBECSHelp.Text = "VBECS Help";
			this.mnuVBECSHelp.Click += new System.EventHandler(this.mnuVBECSHelp_Click);
			// 
			// menuItem5
			// 
			this.menuItem5.Index = 1;
			this.menuItem5.Text = "-";
			// 
			// mnuAbout
			// 
			this.mnuAbout.Index = 2;
			this.mnuAbout.Text = "About VBECS";
			this.mnuAbout.Click += new System.EventHandler(this.mnuAbout_Click);
			// 
			// splitter1
			// 
			this.splitter1.Location = new System.Drawing.Point(0, 0);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(1, 553);
			this.splitter1.TabIndex = 3;
			this.splitter1.TabStop = false;
			// 
			// cmnuPatientUpdates
			// 
			this.cmnuPatientUpdates.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																							   this.mnuUpdatedPatientsToolbar,
																							   this.mnuDeceasedPatientToolbar,
																							   this.mnuPatientMergeToolbar});
			// 
			// mnuUpdatedPatientsToolbar
			// 
			this.mnuUpdatedPatientsToolbar.Index = 0;
			this.mnuUpdatedPatientsToolbar.Text = "&Updated Patients";
			this.mnuUpdatedPatientsToolbar.Click += new System.EventHandler(this.mnuUpdatedPatientsToolbar_Click);
			// 
			// mnuDeceasedPatientToolbar
			// 
			this.mnuDeceasedPatientToolbar.Index = 1;
			this.mnuDeceasedPatientToolbar.Text = "&Deceased Patients";
			this.mnuDeceasedPatientToolbar.Click += new System.EventHandler(this.mnuDeceasedPatientToolbar_Click);
			// 
			// mnuPatientMergeToolbar
			// 
			this.mnuPatientMergeToolbar.Index = 2;
			this.mnuPatientMergeToolbar.Text = "Patient &Merge";
			this.mnuPatientMergeToolbar.Click += new System.EventHandler(this.mnuPatientMergeToolbar_Click);
			// 
			// tbVBECS
			// 
			this.tbVBECS.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
																					   this.tbtnLoginReagents,
																					   this.tbtnDailyQC,
																					   this.tbtnSpacer1,
																					   this.tbtnIncomingShipment,
																					   this.tbtnUnitConfirmation,
																					   this.tbtnModifyUnits,
																					   this.tbtnUnitTyping,
																					   this.tbtnOutgoingShipment,
																					   this.tbtnSpacer2,
																					   this.tbtnAcceptOrders,
																					   this.tbtnMaintainSpecimen,
																					   this.tbtnPatientTesting,
																					   this.tbtnSelectUnits,
																					   this.tbtnIssueUnits,
																					   this.tbtnTransfusionInfo});
			this.tbVBECS.ButtonSize = new System.Drawing.Size(20, 20);
			this.tbVBECS.DropDownArrows = true;
			this.tbVBECS.ImageList = this.imgToolbar;
			this.tbVBECS.Location = new System.Drawing.Point(1, 0);
			this.tbVBECS.Name = "tbVBECS";
			this.tbVBECS.ShowToolTips = true;
			this.tbVBECS.Size = new System.Drawing.Size(791, 28);
			this.tbVBECS.TabIndex = 5;
			this.tbVBECS.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.tbVBECS_ButtonClick);
			// 
			// tbtnLoginReagents
			// 
			this.tbtnLoginReagents.ImageIndex = 3;
			this.tbtnLoginReagents.ToolTipText = "Login Reagents";
			// 
			// tbtnDailyQC
			// 
			this.tbtnDailyQC.ImageIndex = 0;
			this.tbtnDailyQC.ToolTipText = "Daily QC";
			// 
			// tbtnSpacer1
			// 
			this.tbtnSpacer1.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
			// 
			// tbtnIncomingShipment
			// 
			this.tbtnIncomingShipment.ImageIndex = 1;
			this.tbtnIncomingShipment.ToolTipText = "Incoming Shipment";
			// 
			// tbtnUnitConfirmation
			// 
			this.tbtnUnitConfirmation.ImageIndex = 10;
			this.tbtnUnitConfirmation.ToolTipText = "Unit Confirmation";
			// 
			// tbtnModifyUnits
			// 
			this.tbtnModifyUnits.ImageIndex = 4;
			this.tbtnModifyUnits.ToolTipText = "Modify Units";
			// 
			// tbtnUnitTyping
			// 
			this.tbtnUnitTyping.ImageIndex = 11;
			this.tbtnUnitTyping.ToolTipText = "Unit Antigen Typing";
			// 
			// tbtnOutgoingShipment
			// 
			this.tbtnOutgoingShipment.ImageIndex = 6;
			this.tbtnOutgoingShipment.ToolTipText = "Outgoing Shipment";
			// 
			// tbtnSpacer2
			// 
			this.tbtnSpacer2.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
			// 
			// tbtnAcceptOrders
			// 
			this.tbtnAcceptOrders.ImageIndex = 5;
			this.tbtnAcceptOrders.ToolTipText = "Accept Orders";
			// 
			// tbtnMaintainSpecimen
			// 
			this.tbtnMaintainSpecimen.ImageIndex = 9;
			this.tbtnMaintainSpecimen.ToolTipText = "Maintain Specimen";
			// 
			// tbtnPatientTesting
			// 
			this.tbtnPatientTesting.ImageIndex = 7;
			this.tbtnPatientTesting.ToolTipText = "Patient Testing";
			// 
			// tbtnSelectUnits
			// 
			this.tbtnSelectUnits.ImageIndex = 8;
			this.tbtnSelectUnits.ToolTipText = "Select Units";
			// 
			// tbtnIssueUnits
			// 
			this.tbtnIssueUnits.ImageIndex = 2;
			this.tbtnIssueUnits.ToolTipText = "Issue Units";
			// 
			// tbtnTransfusionInfo
			// 
			this.tbtnTransfusionInfo.ImageIndex = 12;
			this.tbtnTransfusionInfo.ToolTipText = "Post-Transfusion Details";
			// 
			// imgToolbar
			// 
			this.imgToolbar.ImageSize = new System.Drawing.Size(16, 16);
			this.imgToolbar.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imgToolbar.ImageStream")));
			this.imgToolbar.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// tmrPatientAlerts
			// 
			this.tmrPatientAlerts.Tick += new System.EventHandler(this.tmrPatientAlerts_Tick);
			// 
			// tmrOrderAlerts
			// 
			this.tmrOrderAlerts.Tick += new System.EventHandler(this.tmrOrderAlerts_Tick);
			// 
			// lvOrders
			// 
			this.lvOrders.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lvOrders.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																					   this.columnHeader7,
																					   this.columnHeader1,
																					   this.columnHeader2,
																					   this.columnHeader3,
																					   this.columnHeader4,
																					   this.columnHeader5,
																					   this.columnHeader9,
																					   this.columnHeader6});
			this.lvOrders.Dock = System.Windows.Forms.DockStyle.Fill;
			this.lvOrders.FullRowSelect = true;
			this.lvOrders.Location = new System.Drawing.Point(0, 20);
			this.lvOrders.MultiSelect = false;
			this.lvOrders.Name = "lvOrders";
			this.lvOrders.Size = new System.Drawing.Size(20, 0);
			this.lvOrders.SmallImageList = this.imglistSmall;
			this.lvOrders.TabIndex = 7;
			this.lvOrders.View = System.Windows.Forms.View.Details;
			this.lvOrders.DoubleClick += new System.EventHandler(this.lvOrders_DoubleClick);
			this.lvOrders.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvOrders_ColumnClick);
			this.lvOrders.SelectedIndexChanged += new System.EventHandler(this.lvOrders_SelectedIndexChanged);
			// 
			// columnHeader7
			// 
			this.columnHeader7.Text = "";
			this.columnHeader7.Width = 20;
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Urgency";
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Patient Name";
			this.columnHeader2.Width = 100;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Patient ID";
			this.columnHeader3.Width = 80;
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "Order";
			this.columnHeader4.Width = 80;
			// 
			// columnHeader5
			// 
			this.columnHeader5.Text = "Date Wanted";
			this.columnHeader5.Width = 100;
			// 
			// columnHeader9
			// 
			this.columnHeader9.Text = "Lab Order No.";
			this.columnHeader9.Width = 80;
			// 
			// columnHeader6
			// 
			this.columnHeader6.Text = "CPRS Order No.";
			this.columnHeader6.Width = 90;
			// 
			// pnlOrders
			// 
			this.pnlOrders.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.pnlOrders.BackColor = System.Drawing.SystemColors.Control;
			this.pnlOrders.Controls.Add(this.lvOrders);
			this.pnlOrders.Controls.Add(this.btnCloseOrders);
			this.pnlOrders.Controls.Add(this.lblOrders);
			this.pnlOrders.Location = new System.Drawing.Point(660, 508);
			this.pnlOrders.Name = "pnlOrders";
			this.pnlOrders.Size = new System.Drawing.Size(20, 20);
			this.pnlOrders.TabIndex = 9;
			this.pnlOrders.Visible = false;
			// 
			// btnCloseOrders
			// 
			this.btnCloseOrders.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCloseOrders.BackColor = System.Drawing.SystemColors.Control;
			this.btnCloseOrders.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.btnCloseOrders.Image = ((System.Drawing.Image)(resources.GetObject("btnCloseOrders.Image")));
			this.btnCloseOrders.Location = new System.Drawing.Point(0, 0);
			this.btnCloseOrders.Name = "btnCloseOrders";
			this.btnCloseOrders.Size = new System.Drawing.Size(20, 20);
			this.btnCloseOrders.TabIndex = 9;
			this.btnCloseOrders.Click += new System.EventHandler(this.btnCloseOrders_Click);
			// 
			// lblOrders
			// 
			this.lblOrders.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.lblOrders.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblOrders.Dock = System.Windows.Forms.DockStyle.Top;
			this.lblOrders.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblOrders.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.lblOrders.Location = new System.Drawing.Point(0, 0);
			this.lblOrders.Name = "lblOrders";
			this.lblOrders.Size = new System.Drawing.Size(20, 20);
			this.lblOrders.TabIndex = 8;
			this.lblOrders.Text = "New or Updated Orders";
			this.lblOrders.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// tmrDateTime
			// 
			this.tmrDateTime.Interval = 1000;
			this.tmrDateTime.Tick += new System.EventHandler(this.tmrDateTime_Tick);
			// 
			// FrmVbecs
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.SystemColors.AppWorkspace;
			this.ClientSize = new System.Drawing.Size(792, 553);
			this.Controls.Add(this.pnlOrders);
			this.Controls.Add(this.tbVBECS);
			this.Controls.Add(this.statusBar1);
			this.Controls.Add(this.splitter1);
			this.HelpButton = true;
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.hlpHelp.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.TableOfContents);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.IsMdiContainer = true;
			this.Menu = this.mnuMain;
			this.MinimumSize = new System.Drawing.Size(800, 580);
			this.Name = "FrmVbecs";
			this.RequiredFieldsLabel = true;
			this.hlpHelp.SetShowHelp(this, true);
			this.hlphelpChm.SetShowHelp(this, true);
			this.ShowInTaskbar = true;
			this.KeyDown += new System.Windows.Forms.KeyEventHandler(this.FrmVbecs_KeyDown);
			this.Controls.SetChildIndex(this.splitter1, 0);
			this.Controls.SetChildIndex(this.statusBar1, 0);
			this.Controls.SetChildIndex(this.tbVBECS, 0);
			this.Controls.SetChildIndex(this.pnlOrders, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelUser)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelDivision)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelTimeZone)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelOrderAlert)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelPatientAlert)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelVistALink)).EndInit();
			this.pnlOrders.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Events

		/// <summary>
		/// Activated Event
		/// </summary>
		/// <param name="e"></param>
		protected override void OnActivated( System.EventArgs e )
		{
			if( !_formFirstTimeActivated ) 
				return;			

			// The following code block executes exactly once during application's lifetime 
			// (assuming that main form was created and shown)

			_formFirstTimeActivated = false;			
			
			this.Refresh();
			PerformAppStartupInit();
		}

		private void tbVBECS_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{
			if (e.Button == this.tbtnAcceptOrders)
			{
				mnuAcceptOrders_Click(sender,e);
			}
			else if (e.Button == this.tbtnDailyQC)
			{
				mnuEnterDailyQCResults_Click(sender,e);
			}
			else if (e.Button == this.tbtnIncomingShipment)
			{
				mnuIncomingShipment_Click(sender,e);
			}
			else if (e.Button == this.tbtnIssueUnits)
			{
				mnuIssueBlood_Click(sender,e);
			}
			else if (e.Button == this.tbtnLoginReagents)
			{
				mnuLoginReagents_Click(sender,e);
			}
			else if (e.Button == this.tbtnMaintainSpecimen)
			{
				mnuSpecimen_Click(sender,e);
			}
			else if (e.Button == this.tbtnModifyUnits)
			{
				mnuModifyUnits_Click(sender,e);
			}
			else if (e.Button == this.tbtnOutgoingShipment)
			{
				mnuNewOutgoingShipment_Click(sender,e);
			}
			else if (e.Button == this.tbtnPatientTesting)
			{
				mnuPatientTesting_Click(sender,e);
			}
			else if (e.Button == this.tbtnSelectUnits)
			{
				mnuSelectUnits_Click(sender,e);
			}
			else if (e.Button == this.tbtnUnitConfirmation)
			{
				mnuABORhConfirmation_Click(sender,e);
			}
			else if (e.Button == this.tbtnUnitTyping)
			{
				mnuUnitAntigenTyping_Click(sender,e);
			}
			else if (e.Button == this.tbtnTransfusionInfo)
			{
				mnuPostTransfusionDetails_Click(sender,e);
			}
		}

		#endregion

		#region Methods

		/// <newpara> Function Name: Main</newpara>
		/// <newpara> Developers: Cameron Taylor</newpara>
		/// <newpara> Site Name: Hines OIFO </newpara>
		/// <newpara> Date Created: 3/27/2003</newpara>
		/// <summary> Description: Application Main function. Displays Splash Screen, and loads application</summary>
		/// <returns>N/A</returns>
		[STAThread]
        static void Main()
        {
#if DESIGN
			GuiMessenger.ShowMessageBox( Common.StrRes.SysErrMsg.Common.AttemptToRunInDesignConfiguration() );
			ExitApplication( false, true  );
			return;
#endif

           try
            {
                initialize_dependencies();
                _logger.Debug("All dependencies successfully initialized");

                InitializeGlobalExceptionHandling();

                using (new VbecsAppStartupLock())
                {

#if !DEBUG  // Splash screen should appear only when not debugging
					// Don't move splash screen to be shown before sync lock checks because 
					// when the splash screen is closed and there's no main window yet, it closes 
					// all open dialogs. 
					new FrmSplash().Show();
#endif
                    Application.DoEvents();

                    AppMainForm = new FrmVbecs();
                    //log4net
                    _logger.Debug("Start VBECS application");
                    //log4net
                    Application.Run(AppMainForm);
                }
            }
           catch (AppLockingException ex)
           {
               GuiMessenger.ShowMessageBox(ex.Item);
           }
           finally
           {
               AppMainForm = null;
               ExitApplication(true, false); // Exiting program - without this user could be trapped in an infinite loop
           }
        }


        static private void initialize_dependencies()
        {
            //Globally setup log output file name
            log4net.GlobalContext.Properties["LogName"] = Path.GetFileNameWithoutExtension(Assembly.GetEntryAssembly().Location);
            log4net.GlobalContext.Properties["LogNameDated"] = Path.GetFileNameWithoutExtension(Assembly.GetEntryAssembly().Location) + DateTime.Now.ToString("_MM-dd-yyyy");

            var log4NetFile = Path.Combine(Path.GetDirectoryName(typeof(FrmVbecs).Assembly.Location) ?? ".", ConfigurationManager.AppSettings.Get("log4net.Config"));
            log4net.Config.XmlConfigurator.ConfigureAndWatch(new FileInfo(log4NetFile));
            
            //Two configuration files are necessary since object in first file should be created and ready for object in the second one.
            var common = @"file://" + Path.Combine(Path.GetDirectoryName(typeof(FrmVbecs).Assembly.Location) ?? ".", ConfigurationManager.AppSettings.Get("SpringConfigFileCommon"));
            var spring = @"file://" + Path.Combine(Path.GetDirectoryName(typeof(FrmVbecs).Assembly.Location) ?? ".", ConfigurationManager.AppSettings.Get("SpringConfigFile"));
            DiContext.AppContext = new XmlApplicationContext(new[] { common, spring });

            //Here is the once-per-class call to initialize the log object
            //We have to do it after Spring.NET objects initialization.
            _logger = LogManager.Instance().LoggerLocator.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);
        }

		/// <summary>
		/// Had to override WndProc because neither overriding OnClosing nor listening to Closing event 
		/// had the functionality needed (do confirmation before attempting to close child MDI windows). 
		/// </summary>
		/// <param name="m"></param>
		protected override void WndProc( ref System.Windows.Forms.Message m ) 
		{ 
			if(m.Msg == WM_CLOSE)
			{
				if (ConfirmExitFromVbecsIfNeeded())
				{
					PerformApplicationShutdownCleanup(false);
					Application.Exit();
				}
				else
				{
					return;
				}
			}

			base.WndProc( ref m ); 
		}

		private void PerformAppStartupInit()
		{
            //CR 3454
            string dbVersion = string.Concat(BOL.VbecsVersion.CurrentVersion);
            string exeVersion = Assembly.GetExecutingAssembly().GetName().Version.ToString();
            bool isVBECSRunningInIDE = System.Diagnostics.Debugger.IsAttached;
#if DEBUG || UNIT_TEST || DESIGN
            isVBECSRunningInIDE = true;
#endif

            if (!isVBECSRunningInIDE)
            {
                if (!string.Equals(dbVersion, exeVersion))
                {
                    GuiMessenger.ShowMessageBox(StrRes.SysErrMsg.Common.MisMatchedBuild(exeVersion, dbVersion));
                    ExitApplication(false, true);
                    return;
                }
            }

		    if( !LogonUserToVbecs() )
			{
                ExitApplication( false, true );
				return;
			}

            // Cleanup log files a new Thread
            // NOTE: CleanUpLogFiles function reuses VistACacheRefreshInterval interval and CPT Cache update date in DB.
            // So, it is important indirect dependency. Because of that, CleanUpLogFiles must be called before VistaCache.UpdateCache function.
            Task.Run(() => CleanUpLogFiles()).ContinueWith(
                t =>
                {
                    if (t.Exception != null)
                    {
                        _logger.Warn(string.Format("Log files cleanup failed. Error: {0}", t.Exception.InnerException != null ? t.Exception.InnerException.Message : "null"));
                    }
                    _logger.Debug("Log files cleanup succeeded");
                });

            VistALink.Initialize(new VbecsVistALinkUIBinder(ThisUser, this), ThisUser.UserDuz);
            VistALink.ConnectionStateChanged += VistALinkConnectionStateChangedHandler;

            try
            {
                VistALink.SetPrimaryServer(VistALinkConfig.GetCurrent().GetServerConnectionInfo());
            }
            catch (Exception ex)
            {
                //some problem preparing vista link connection (CR3414)
                _logger.Error("Some problem preparing vista link connection", ex);
                //Don't re-throw since we don't want to crash application if there is not VistALink connection.
                //return;
            }
			
			mnuChangeDivision.Enabled = ( ThisUser.DivisionsAndRoles.EffectiveDivisions.Count > 1 );
			ChangeDivision( true );	

			// Always cache VistA data at startup; use a new Thread
			// so user does not have to wait
            // CR 3304
            Task.Run(() =>
                     {
                         _logger.Debug("Vista Cache Update Initiated");                    
                         VistaCache.UpdateCache(VbecsConfig.Current.VistACacheRefreshInterval);
                     }).ContinueWith(
                t =>
                {
                    if (t.Exception != null)
                    {
                        _logger.Warn(string.Format("Vista Cache Update Failed. Error: {0}", t.Exception.InnerException != null ? t.Exception.InnerException.Message : "null"));
                    }
                    _logger.Debug("Vista Cache Update Succeeded");                    
                });

			// CR 2519
			_purgeMessageLogThread = new Thread(new ThreadStart(PurgeHL7MessageLog));
			_purgeMessageLogThread.Start();

			// CR 2150: Adding beep at startup so that the user knows beeps are working	
			Utility.MessageBeep();
		}

        private static void CleanUpLogFiles()
	    {
            var hier = log4net.LogManager.GetRepository() as Hierarchy;
            if (hier == null)
            {
                _logger.Error("Unable to get appender information, null hierarchy");
                return;
            }
            var rollingFileAppender =
                (FileAppender)hier.GetAppenders().
                                          First(appender => appender.Name.Equals("RollingFile",
                                              StringComparison.InvariantCultureIgnoreCase));

            if (null == rollingFileAppender)
            {
                _logger.Error("RollingFile appender not found");
                return;
            }

            if (null == Path.GetDirectoryName(rollingFileAppender.File))
            {
                _logger.Error("RollingFile appender file name is not available");
                return;
            }

            var logsDir = new DirectoryInfo(Path.GetDirectoryName(rollingFileAppender.File));
            FileInfo[] allLogFiles;
            try
            {
                allLogFiles = logsDir.GetFiles("*.*");
            }
            // This is thrown if even one of the files requires permissions greater 
            // than the application provides. 
            catch (UnauthorizedAccessException e)
            {
                _logger.Error("Not enough privileges to perform logs files cleanup: " + e.Message, e);
                return;
            }
            catch (DirectoryNotFoundException)
            {
                _logger.Error(string.Format("Log files directory not found [{0}]", logsDir.Name));
                return;
            }
            catch (Exception ex)
            {
                _logger.Error("Can't list log files", ex);
                return;
            }

            foreach (var fi in allLogFiles.Where(fi => fi.LastWriteTime < DateTime.Now.Subtract(new TimeSpan(30, 0, 0, 0))))
            {
                try
                {
                    fi.Delete();
                }
                catch (Exception e)
                {
                    _logger.Error("Can't delete file", e);
                    continue;
                }
                _logger.Debug(string.Format("File deleted [{0}]", fi.FullName));
            }   

	    }

	    private bool LogonUserToVbecs()
		{
			try
			{
				using( new WaitCursor() )
					SetThisUser = VbecsUser.LogonToVbecs();
				

				return true;
			}
			catch( VbecsLogonException xcp )
			{
				GuiMessenger.ShowMessageBox( StrRes.SysErrMsg.UC018.VbecsLogonError( Environment.NewLine + Environment.NewLine, xcp.Message ) );
				return false;
			}
		}

		/// <summary>
		/// Public function which updates the main menu bar according to user security level and division configuration
		/// </summary>
		public void UpdateMainFormUIAccordingToUserSecurityAccess()
		{
			if(Common.LogonUser.IsVisuallyImpairedUser)
			{
				this.tbVBECS.Enabled=false;
				this.tbVBECS.Visible = false;
			}
			else
			{
				this.tbVBECS.Enabled=true;
				this.tbVBECS.Visible = true;
			}

			this.mnuConfigureDivision.Enabled		= IsCurrentUserAuthorizedForAnyOfFunctions( 
				FunctionCode.DefineDivisionServiceLevel, 
				FunctionCode.EnableElectronicXMatch, 
				FunctionCode.PopulateICCBBANumber,
				FunctionCode.ConfigureDivision,
				FunctionCode.MaintainLoginMessage);

			this.mnuCannedComments.Enabled			= IsCurrentUserAuthorizedForFunction( FunctionCode.EditAndCreateCannedComments );

			// CR 2553, 2554
			this.mnuEditUnitInformation.Enabled		= IsCurrentUserAuthorizedForFunction( FunctionCode.EditUnitLoginPriortoPatientAssociation );

			this.mnuModifyUnits.Enabled				= 
				this.tbtnModifyUnits.Enabled		= IsCurrentUserAuthorizedForFunction( FunctionCode.StandardAccess );

			this.mnuEditInvoiceText.Enabled			= IsCurrentUserAuthorizedForFunction( FunctionCode.EditConsultativeReports );

			// Level 6 and above can update users, level 3 and above can view users
			if( IsCurrentUserAuthorizedForFunction( FunctionCode.DefineVBECSUsers ) )
			{
				this.mnuUpdateUsers.Text = "Update &User Roles";
				this.mnuUpdateUsers.Enabled = true;
			}
			else if( IsCurrentUserAuthorizedForFunction( FunctionCode.PrintInternalReports ) )
			{
				this.mnuUpdateUsers.Text = "View &User Roles";
				this.mnuUpdateUsers.Enabled = true;
			}
			else
			{
				this.mnuUpdateUsers.Text = "View &User Roles";
				this.mnuUpdateUsers.Enabled = false;
			}

			this.mnuWorkloadCodes.Enabled				= IsCurrentUserAuthorizedForFunction( FunctionCode.AssignWorkLoadCodes );

			this.mnuTransfusionEffectiveness.Enabled		= 
				this.mnuTransfusionComplicationns.Enabled	= 
				this.mnuMSBOS.Enabled						= 
				this.mnuComponentClasses.Enabled			= 
				this.mnuEditInvoiceText.Enabled				= IsCurrentUserAuthorizedForFunction( FunctionCode.EditConsultativeReports );

			this.mnuAntibodies.Enabled					= IsCurrentUserAuthorizedForFunction( FunctionCode.EditAntigenFrequencyTable );

			this.mnuCollectionFacilities.Enabled		= IsCurrentUserAuthorizedForFunction( FunctionCode.ActivateEditShipperInformation );
 
			// Supervisor menu
			// CR 2553, 2554
			this.mnuRemoveFinalUnitStatus.Enabled				= IsCurrentUserAuthorizedForFunction( FunctionCode.RemoveFinalStatus );
			this.mnuDocumentABOIncompatibleTransfusion.Enabled	= IsCurrentUserAuthorizedForFunction( FunctionCode.EditBloodUnitLongitudinalRecord );
			this.mnuJustifyABORhChange.Enabled					= IsCurrentUserAuthorizedForFunction( FunctionCode.EditPermanentRecordPatientHistoricABORh );

			this.mnuInvalidatePatientTesting.Enabled = IsCurrentUserAuthorizedForFunction( Common.FunctionCode.EditPatientRecordVerifiedDataTestResults );

			// BR_2.43
			// Testing Options unavailable for Transfusion Only Facility
			this.mnuMaintainMinLevels.Enabled			= (IsCurrentUserAuthorizedForFunction(FunctionCode.EditBloodUnitLongitudinalRecord) && ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator);
			this.mnuConfigureDailyQC.Enabled			= (IsCurrentUserAuthorizedForFunction(FunctionCode.EditConsultativeReports) && ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator);
			this.mnuUnitAntigenTyping.Enabled			= (IsCurrentUserAuthorizedForFunction(FunctionCode.StandardAccess) && ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator);
			this.tbtnUnitTyping.Enabled					= (IsCurrentUserAuthorizedForFunction(FunctionCode.StandardAccess) && ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator);
			this.mnuABORhConfirmation.Enabled			= (IsCurrentUserAuthorizedForFunction(FunctionCode.StandardAccess) && ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator);
			this.tbtnUnitConfirmation.Enabled			= (IsCurrentUserAuthorizedForFunction(FunctionCode.StandardAccess) && ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator);
			this.mnuShipmentABORhConfirmation.Enabled	= (IsCurrentUserAuthorizedForFunction(FunctionCode.StandardAccess) && ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator);
			this.mnuEnterDailyQCResults.Enabled			= (IsCurrentUserAuthorizedForFunction(FunctionCode.StandardAccess) && ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator);
			this.tbtnDailyQC.Enabled					= (IsCurrentUserAuthorizedForFunction(FunctionCode.StandardAccess) && ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator);
			this.mnuLoginReagents.Enabled				= (IsCurrentUserAuthorizedForFunction(FunctionCode.StandardAccess) && ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator);
			this.tbtnLoginReagents.Enabled				= (IsCurrentUserAuthorizedForFunction(FunctionCode.StandardAccess) && ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator);
			this.mnuUpdateInventory.Enabled				= (IsCurrentUserAuthorizedForFunction(FunctionCode.StandardAccess) && ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator);
			this.mnuViewPrintInventory.Enabled			= (IsCurrentUserAuthorizedForFunction(FunctionCode.StandardAccess) && ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator);
			this.mnuFreeDirectedUnit.Enabled			= (IsCurrentUserAuthorizedForFunction(FunctionCode.ReleaseDirectedUnits) && ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator);
			
			// Define the secuity behavior for the Patient Deceased\Merge\Updated menus
			//
			this.mnuPatientMerge.Enabled = 
				this.mnnuDeceasedPatients.Enabled = 
				this.mnuUpdatedPatients.Enabled = IsCurrentUserAuthorizedForFunction(FunctionCode.StandardAccess);
		}


		private void PerformPostUserDivisionLogonActions()
		{
			this.mnuFile.Enabled = true;
			this.mnuHelp.Enabled = true;
			this.mnuEdit.Enabled = true;
			this.mnuShipment.Enabled = true;
			this.mnuPatients.Enabled = true;
			this.mnuBloodUnits.Enabled = true;
			this.mnuOrders.Enabled = true;
			this.mnuTools.Enabled = true;
			this.mnuReagents.Enabled = true;
			this.mnuReports.Enabled = true;
			this.tbVBECS.Enabled = true;

			UpdateMainFormUIAccordingToUserSecurityAccess();

			this._division = new BOL.Division(LogonUser.LogonUserDivisionCode);
			this.tmrOrderAlerts.Interval = (this._division.DivisionAlerts.IconRefreshRate * 1000);
            VbecsBaseForm.LockInactivityTimeout = this._division.LockInactivityTimeoutMin;      //CR3311


			LoadDivisionTimeZone();
			UpdateStatusBar();

            DlgDivisionLogonPopup.DisplayLogonMessagePopup( ThisUser.CurrentDivisionRole.Division, this );
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void VistALinkConnectionStateChangedHandler( object sender, VistALinkConnectionStateChangedEventArgs e )
		{
            lock (this)
		    {
                UpdateVistALinkStatusBarPanel(e.IsAvailable);
            }
		    //
			if ( e.IsAvailable )
			{
				// Re-send Dss extract data that is still pending
				// CR 2958
				if ( _dssExtractThread == null || _dssExtractThread != null && !_dssExtractThread.IsAlive )
				{
					_dssExtractThread = new Thread(new ThreadStart(HandleDssExtract));
					_dssExtractThread.Start();
				}
			}
		}

		private void UpdateStatusBar()
		{
			UpdateUserStatusBarPanel();
			UpdateDivisionStatusBarPanel();
			UpdateTimeZoneStatusBarPanel();
			UpdateVistALinkStatusBarPanel( VistALink.IsAvailable );
			//
			_lastPatientUpdateCheck = new DateTime(1900,1,1);
			_lastOrderUpdateCheck = new DateTime(1900,1,1);
			//
			
			DateTime checkDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			lvOrders.Items.Clear();
			UpdateOrderAlertStatusBarPanel();
			this._lastOrderUpdateCheck = checkDate;

			statusBarPanelPatientAlert.ToolTipText = "";
            Invoke(new MethodInvoker(delegate { statusBarPanelPatientAlert.Icon = controls.VbecsIcon.TransparentAlert.Icon; }));
			UpdatePatientAlertStatusBarPanel();
			this._lastPatientUpdateCheck = checkDate;
		}

		/// <summary>
		/// UpdateUserStatusBarPanel
		/// </summary>
		public void UpdateUserStatusBarPanel()
		{
            this.Invoke(new MethodInvoker(delegate { statusBarPanelUser.Text = String.Concat("User: ", ThisUser.UserName);}));    
		}

		/// <summary>
		/// UpdateDivisionStatusBarPanel
		/// </summary>
		public void UpdateDivisionStatusBarPanel()
		{
            this.Invoke(new MethodInvoker(delegate { statusBarPanelDivision.Text = String.Concat("Division: ", ThisUser.CurrentDivisionRole.Division.DivisionName, " (", ThisUser.CurrentDivisionRole.Division.ServiceType, ")"); }));
		}

        /// <summary>
        /// UpdateDivisionAndAlertRefreshRate - CR3400 - to refresh settings after saving UC_9 Configure Division
        /// </summary>
        public void UpdateDivisionAndAlertRefreshRate()
        {
            this._division = new BOL.Division(LogonUser.LogonUserDivisionCode);

            UpdateStatusBar();
        }

		/// <summary>
		/// UpdateTimeZoneStatusBarPanel
		/// </summary>
		public void UpdateTimeZoneStatusBarPanel()
		{
			//Don't go to the server for the date, just add the previously identified difference
			//between the server and the local date time.
			this._displayDateTime = DateTime.Now.Add(_serverTimeDifference);
            this.Invoke(new MethodInvoker(delegate { statusBarPanelTimeZone.Text = String.Concat("Time: ", _displayDateTime.ToString("HH:mm "), this._divisionTimeZoneText).Trim(); }));    
		}

        //CR3414 & CR3413
		private void UpdateVistALinkStatusBarPanel( bool isAvailable )
		{
            if (statusBarPanelVistALink.Parent.InvokeRequired)
            {
                statusBarPanelVistALink.Parent.BeginInvoke(new Action(() =>
                {
                    _logger.Debug("UpdateVistALinkStatusBarPanel delegate invoked");
                    statusBarPanelVistALink.Icon =
                        (isAvailable ? controls.VbecsIcon.VistALinkConnected : controls.VbecsIcon.VistALinkDown).Icon;
                }));
            }
            else
            {
                statusBarPanelVistALink.Icon =
                        (isAvailable ? controls.VbecsIcon.VistALinkConnected : controls.VbecsIcon.VistALinkDown).Icon;
            }
            _vistalinkAvailable = isAvailable;
		}

		private void ChangeDivision( bool isInitialDivisionSelection )
		{
			if( !isInitialDivisionSelection && !TryCloseAllChildFormsWithUserInteraction() )				
				return;

			if( !SetUserDivisionSelection( isInitialDivisionSelection ) )
				return;

			//The user is just loggin in, or switching divisions, so -- cleanup any locks that might be hanging
			FrmAppMainFormBase.PerformLockingCleanup();

			this.Refresh();
			
			//using( new WaitCursor() )
			{
				if( isInitialDivisionSelection )
					VistALink.Connect();
				else
					VistALink.ChangeDivision();
			}

			this.Refresh();

			PerformPostUserDivisionLogonActions();

			this.Refresh();
		}


		private bool SetUserDivisionSelection( bool isInitialDivisionSelection )
		{
			// CR2497: This method was reorganized to call the correct code.  The call to SetDefaultPrinter
			// has been moved to a place where it will always be called.  This was done by adding an if/else
			// and putting the call after.

			if( ThisUser.DivisionsAndRoles.EffectiveDivisions.Count == 1 )
			{
				ThisUser.LogonToDivision( ThisUser.DivisionsAndRoles.EffectiveDivisions[0].DivisionCode );
			}
			else
			{

				var dlg = new DlgSelectDivision( ThisUser.DivisionsAndRoles.EffectiveDivisions, isInitialDivisionSelection ? null : ThisUser.CurrentDivisionRole.Division );	

				for(;;)
				{
					dlg.ShowDialog( this );
					this.Refresh();

					if( dlg.DialogResult == DialogResult.OK ) 
						break;

					if( !isInitialDivisionSelection )
						return false;
				
					if( ConfirmExitFromVbecsIfNeeded() )
					{
						DontAskForAppExitConfirmation = true;

						ExitApplication( true, true );
						return false; // Be careful... ExitApplication returns control immediately, terminating the app on another thread.
					}
				}
				ThisUser.LogonToDivision( dlg.ChosenDivision.DivisionCode );
			}
		
			// Added per CR 2320
			if (!ThisUser.SetDefaultPrinter())
			{
				// BR_18.10
				GuiMessenger.ShowMessageBox(StrRes.InfoMsg.UC018.ReportPrinterNotAvailable());
			}
			return true;
		}

		private bool ConfirmExitFromVbecsIfNeeded()
		{			
			if( DontAskForAppExitConfirmation )
				return true;

			return (GuiMessenger.ShowMessageBox( StrRes.ConfMsg.Common.ExitVbecs() ) == DialogResult.Yes);
		}




		private void LoadDivisionTimeZone()
		{
			this._divisionTimeZoneText = BOL.VBECSDateTime.GetDivisionTimeZoneAbbreviation();
			//For performance reasons, we will only check the server time once.
			//Then we'll identify the difference between the server and the local time
			//and display the local time plus difference.
			DateTime serverDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			DateTime localDateTime = DateTime.Now;
			_serverTimeDifference = serverDateTime.Subtract(localDateTime);
			this._displayDateTime = localDateTime.Add(_serverTimeDifference);
			tmrDateTime.Enabled = true;
		}

		private bool TryToAutomaticallyCloseAllChildForms()
		{
			foreach( Form _form in this.MdiChildren )
				_form.Close();

			this.Refresh();

			return (this.MdiChildren.Length == 0);
		}

		private bool TryCloseAllChildFormsWithUserInteraction()
		{
			if( this.MdiChildren.Length == 0 )
				return true;

			if( GuiMessenger.ShowMessageBox( StrRes.ConfMsg.UC018.ConfirmClosingAllWindowsBeforeDivisionChange() ) == DialogResult.No )
				return false;

			if( TryToAutomaticallyCloseAllChildForms() )
				return true;

			GuiMessenger.ShowMessageBox( StrRes.ValidMsg.UC018.SomeApplicationFormsAreOpen() );
			return false;
		}

		/// <summary>
		/// DisplayMdiChildForm
		/// </summary>
		/// <param name="formToDisplay"></param>
		public void DisplayMdiChildForm( Form formToDisplay )
		{
			// Trying this code so that we can close a form without having it show up on the screen empty
			if( formToDisplay.DialogResult != System.Windows.Forms.DialogResult.Abort )
			{
				formToDisplay.MdiParent = this;
				formToDisplay.Show();
				this.Refresh();
			}
			else
			{
				formToDisplay.Close();
				formToDisplay.Dispose();
			}
		}

		private void DisplayInsufficientPrivilegesMessageForMenuItem( MenuItem menuUtem )
		{
			if( menuUtem == null )
				throw( new ArgumentNullException( "menuUtem" ) );

			GuiMessenger.ShowMessageBox( 
				Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges( 
				menuUtem.Text.Replace( "&", String.Empty ) ) );
		}

#if	DEBUG
		private void DebugStopVistALink_Click( object sender, EventArgs e )
		{
			VistALink.Disconnect();
			GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.FrmVbecs.VistALinkClosed());
		}

		private class VistALinkLongQueryTest : Form
		{
			public VistALinkLongQueryTest()
			{
				Button _btnQ = new Button();
				_btnQ.Text = "Query!";
				_btnQ.Click += new EventHandler( HandleClick );

				this.Controls.Add( _btnQ );
			}

			private void HandleClick( object sender, EventArgs e )
			{
				((Button)sender).Enabled = false;
				DAL.VAL.BloodBankUsers.GetBloodBankUsers();
				((Button)sender).Enabled = true;
			}
		}

		private void DebugRunLongVistALinkQuery_Click( object sender, EventArgs e )
		{			
			new VistALinkLongQueryTest().ShowDialog( this );
		}
#endif

		#endregion

		#region File Menu

		private void mnuExit_Click(object sender, System.EventArgs e)
		{
			bool confirmExit = false;
			confirmExit = (GuiMessenger.ShowMessageBox( StrRes.ConfMsg.Common.ExitVbecs() ) == DialogResult.Yes);
			if(confirmExit)
			{
				PerformApplicationShutdownCleanup(false);
				Application.Exit();
			}
		}

		private void mnuChangeDivision_Click(object sender, System.EventArgs e)
		{			
			ChangeDivision( false );
		}

		#endregion

		#region Other Menus

		#region Help Menu
		/// <newpara> Function Name: mnuAbout_Click</newpara>
		/// <newpara> Developers: Cameron Taylor</newpara>
		/// <newpara> Site Name: Hines OIFO </newpara>
		/// <newpara> Date Created: 4/30/2002</newpara>
		/// <summary> Description: mnuAbout menu Click event. Display About box dialog</summary>
		/// <param name="sender">Object</param>
		/// <param name="e">EventArgs</param>
		/// <returns>N/A</returns>
		private void mnuAbout_Click(object sender, System.EventArgs e)
		{
			new FrmAboutBox("VistA Blood Establishment Computer Software (VBECS)").ShowDialog( this );
		}
		/// <newpara> Function Name: mnuVBECSHelp_Click</newpara>
		/// <newpara> Developers: Carrie Van Stedum</newpara>
		/// <newpara> Site Name: Hines OIFO </newpara>
		/// <newpara> Date Created: 1/17/2005</newpara>
		/// <summary> Description: mnuVBECSHelp_Click menu Click event. Display help file with nothing selected </summary>
		/// <param name="sender">Object</param>
		/// <param name="e">EventArgs</param>
		/// <returns>N/A</returns>
		private void mnuVBECSHelp_Click(object sender, System.EventArgs e)
		{
			
			System.Windows.Forms.Help.ShowHelp(this, Environment.CurrentDirectory+"\\VBECS.chm", System.Windows.Forms.HelpNavigator.TableOfContents);
		}

		#endregion

		#region Blood Units Menu

		private void mnuBloodAvailability_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new DlgPatientAvailabilityType() );
		}

		private void mnuABORhConfirmation_Click(object sender, System.EventArgs e)
		{
			FrmAboRHSelectInvoice _frmABORhInvoice = new FrmAboRHSelectInvoice(false);

			if( _frmABORhInvoice.ShowDialog( this ) == DialogResult.OK )
			{
				if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
				{
					DisplayMdiChildForm( new FrmAboRHConfirmProcess(_frmABORhInvoice.TestDateTime, _frmABORhInvoice.TestUser, _frmABORhInvoice.AutomatedInstrName, _frmABORhInvoice.AutomatedInstrQCd, _frmABORhInvoice.RackGuid, _frmABORhInvoice.PerformAntiD, _frmABORhInvoice.RackNotQCComment ) );
				}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
				}
			}
		}

		private void mnuDiscardQuarantineRelease_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				DisplayMdiChildForm( new FrmDiscardQuarantine() );
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void mnuEditFinancialData_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				DisplayMdiChildForm( new FrmEditUnitFinancial() );
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}
		/// <summary>
		/// Implements BR_6.02
		/// </summary>
		private void mnuModifyUnits_Click(object sender, System.EventArgs e)
		{
			//BR_6.02
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				//Adding 9/30/2004, per request of VanStedum.
				BOL.Division divCheck = new BOL.Division(Common.LogonUser.LogonUserDivisionCode);
				if (divCheck.LocalSupplierGuid == System.Guid.Empty)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC026.DivisionNotSetupToContinue());
				}
				else
					DisplayMdiChildForm( new DlgModifyUnit() );
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("modify blood units"));
			}
		}

		private void mnuGenerateLabel_Click(object sender, System.EventArgs e)
		{
			new DlgGenerateFullFaceLabel().ShowDialog( this );
		}

		private void mnuUnitAntigenTyping_Click(object sender, System.EventArgs e)
		{
			if( IsCurrentUserAuthorizedForFunction( FunctionCode.StandardAccess ) )
			{
				//BR_2.43
				if( ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator )
					new DlgSelectSpecificities().ShowDialog(this);
				else
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.FunctionUnavailable(mnuUnitAntigenTyping.Text.Replace("&", String.Empty)));
			}
			else
			{
				DisplayInsufficientPrivilegesMessageForMenuItem( mnuUnitAntigenTyping );
			}
		}

		private void mnuPrintTagFormUnit_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmPrintCautionTagByUnit() );
		}

		private void mnuReleaseUnitsFromAssignment_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmReleaseUnits() );
		}

		private void mnuEditUnitInformation_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmEditUnitProcessing() );
		}

		private void mnuReturnIssuedUnits_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				if( !VistALink.EnsureAvailability() ) return;

				DlgReturnUnitsInfo _dlgReturnUnitsInfo = new DlgReturnUnitsInfo();

				if( _dlgReturnUnitsInfo.ShowDialog( this ) == DialogResult.OK )
					DisplayMdiChildForm( new FrmReturnIssuedUnits(_dlgReturnUnitsInfo.ReturnedDateTime, _dlgReturnUnitsInfo.ReturnedTechId, true) );
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void mnuFreeDirectedUnit_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmFreeDirectedUnit() );
		}

		private void mnuSelectUnits_Click(object sender, System.EventArgs e)
		{
			if( IsCurrentUserAuthorizedForFunction( FunctionCode.StandardAccess ) )
				DisplayMdiChildForm( new FrmPendingTaskList( false ) );
			else
				DisplayInsufficientPrivilegesMessageForMenuItem( mnuSelectUnits );
		}

		#endregion

		#region Orders Menu
		
		private void mnuAcceptOrders_Click(object sender, System.EventArgs e)
		{
			if ( IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				if( !VistALink.EnsureAvailability() )
					return;

				DisplayMdiChildForm( new FrmPendingOrderSearch() );

			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void mnuSpecimen_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmMaintainSpecimen() );
		}

		private void mnuOrderReflexTests_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				DisplayMdiChildForm( new FrmOrderSpecimenReflex() );
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void mnuOrderDataReport_Click(object sender, System.EventArgs e)
		{
			DlgSelectPatientOrder dlg = new DlgSelectPatientOrder(new BOL.OrderReport());
			if( dlg.ShowDialog(this) != DialogResult.OK )
			{
				return;
			}
			DisplayMdiChildForm( new FrmOrderHistoryReport(dlg.OrderReport) );
		}

		#endregion

		#region Reagents Menu
		
		private void mnuEnterDailyQCResults_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new DlgSelectRack() );
		}

		private void mnuConfigureDailyQC_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.EditConsultativeReports))
			{
				DisplayMdiChildForm( new FrmConfigureReagent() );
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void mnuLoginReagents_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmLogInReagents() );
		}

		private void mnuUpdateInventory_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				DisplayMdiChildForm( new FrmUpdateReagentInventory() );
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void mnuViewPrintInventory_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmReagentInventory() );
		}

		private void mnuMaintainMinLevels_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.MaintainMinimumLevels))
			{
				DisplayMdiChildForm( new FrmMaintainReagentMinLevels() );
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		#endregion

		#region Reports Menu

		private void mnuMedicationProfile_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmMedProfile() );
		}

		private void mnuAuditTrail_Click(object sender, System.EventArgs e)
		{
			DlgAuditTrailCriteria dlg = new DlgAuditTrailCriteria(this);
			dlg.ShowDialog(this);
		}

		private void mnuExceptionReport_Click(object sender, System.EventArgs e)
		{
			DlgExceptionReportCriteria dlg = new DlgExceptionReportCriteria(this);
			dlg.ShowDialog(this);
		}
		
		private void mnuTestingWorklist_Click(object sender, System.EventArgs e)
		{
			DlgTestingWorklistCriteria dlg = new DlgTestingWorklistCriteria();
			if( dlg.ShowDialog(this) != DialogResult.OK )
			{
				return;
			}
			DisplayMdiChildForm( new FrmTestingWorklistReport(dlg.TestingWorklistReport) );
		}

		private void mnuDivisionTransfusionReport_Click(object sender, System.EventArgs e)
		{
			DlgTransfusionReportCriteria dlg = new DlgTransfusionReportCriteria(this);
			dlg.ShowDialog(this);
		}

		private void mnuCostAccountingReport_Click(object sender, System.EventArgs e)
		{
			DlgCostAccountingReportCriteria dlg = new DlgCostAccountingReportCriteria(this);
			dlg.ShowDialog(this);
		}

		private void mnuIssuedReturnedReport_Click(object sender, System.EventArgs e)
		{
			DlgIssuedReturnedReportCriteria dlg = new DlgIssuedReturnedReportCriteria();
			if( dlg.ShowDialog(this) != DialogResult.OK )
			{
				return;
			}
			DisplayMdiChildForm( new FrmIssuedReturnedReport(dlg.IssueReturnReport) );
		}

		private void mnuFinalizePrintTrw_Click(object sender, System.EventArgs e)
		{
			DlgSelectCompletedTrw dlg = new DlgSelectCompletedTrw();
			if( dlg.ShowDialog(this) != DialogResult.OK )
			{
				return;
			}
			DisplayMdiChildForm( new FrmGenerateTrwReport(dlg.OrderedTestGuid, dlg.PatientTransfusionReactionGuid, dlg.PartialSaveId ));
		}

		private void mnuDivisionWorkloadReport_Click(object sender, System.EventArgs e)
		{
			DlgDivisionWorkloadReportCriteria dlg = new DlgDivisionWorkloadReportCriteria(this);
			dlg.ShowDialog(this);
		}

		private void mnuUnitHistoryReport_Click(object sender, System.EventArgs e)
		{
			DlgUnitDataReportCriteria dlg = new DlgUnitDataReportCriteria();
			if (dlg.ShowDialog(this) != DialogResult.OK)
			{
				return;
			}
			if(dlg.BloodUnitReport.IsScheduled)
				dlg.BloodUnitReport.Schedule();
			else
				DisplayMdiChildForm( new FrmUnitDataReport(dlg.BloodUnitReport) );
		}

		private void mnuTransfusionRequirementsReport_Click(object sender, System.EventArgs e)
		{
			DlgTransfusionRequirementsReportCriteria dlg = new DlgTransfusionRequirementsReportCriteria();
			if( dlg.ShowDialog(this) != DialogResult.OK )
			{
				return;
			}
			if(dlg.TransfusionRequirementsReport.IsScheduled)
				dlg.TransfusionRequirementsReport.Schedule();
			else
				DisplayMdiChildForm( new FrmTransfusionRequirementsReport(dlg.TransfusionRequirementsReport, dlg.TransfusionRequirementsReportData) );
		}

		private void mnuTransfusionComplicationsReport_Click(object sender, System.EventArgs e)
		{
			if( !VistALink.EnsureAvailability() )
				return;

			DlgTransfusionComplicationDetails dlg = new DlgTransfusionComplicationDetails();
			if( dlg.ShowDialog(this) != DialogResult.OK )
			{
				return;
			}
			if(dlg.TransfusionComplicationReport.IsScheduled)
				dlg.TransfusionComplicationReport.Schedule();
			else
				DisplayMdiChildForm( new FrmTransfusionComplicationsReport(dlg.TransfusionComplicationReport) );
		}

		private void mnuTransfusionEffectivenessReport_Click(object sender, System.EventArgs e)
		{
			if( !VistALink.EnsureAvailability() )
				return;

			DlgTransfusionEffectivenessReportCriteria dlg = new DlgTransfusionEffectivenessReportCriteria();
			if( dlg.ShowDialog(this) != DialogResult.OK )
			{
				return;
			}
			if(dlg.TransfusionEffectivenessReport.IsScheduled)
				dlg.TransfusionEffectivenessReport.Schedule();
			else
				DisplayMdiChildForm( new FrmTransfusionEffectivenessReport(dlg.TransfusionEffectivenessReport) );
		}

		private void mnuInappropriateRequestReport_Click(object sender, System.EventArgs e)
		{
            DlgInappropriateRequestReportCriteria dlg = new DlgInappropriateRequestReportCriteria();

            if (dlg.ShowDialog(this) != DialogResult.OK)
                return;

            if (dlg.InappropriateTransfusionRequestReport.IsScheduled)
            {
                if (!dlg.InappropriateTransfusionRequestReport.IsValid)
                    throw (new BusinessObjectException(Common.StrRes.SysErrMsg.Common.UnableToGenerateReportBecauseSomeRulesAreBroken(dlg.InappropriateTransfusionRequestReport.BrokenRulesCount, dlg.InappropriateTransfusionRequestReport.GetType().Name).ResString));

                dlg.InappropriateTransfusionRequestReport.Schedule();
            }
            else
            {
                DisplayMdiChildForm(new FrmInappropriateRequestReport(dlg.InappropriateTransfusionRequestReport));
            }
		}

		private void mnuPatientHistoryReport_Click(object sender, System.EventArgs e)
		{
			DlgPatientRecordReportCriteria dlg = new DlgPatientRecordReportCriteria();
			if (dlg.ShowDialog(this) != DialogResult.OK)
			{
				return;
			}
			DisplayMdiChildForm( new FrmPatientRecordReport(dlg.Report) );
		}

		private void mnuCTRatioReport_Click(object sender, System.EventArgs e)
		{
			DlgCTRatioReportCriteria dlg = new DlgCTRatioReportCriteria();
			if( dlg.ShowDialog(this) != DialogResult.OK )
			{
				return;
			}
			DisplayMdiChildForm( new FrmCTRatioReport(dlg.CTRatioReport) );
		}

		private void mnuProlongedTransfusionReport_Click(object sender, System.EventArgs e)
		{
            DlgProlongedTransfusionReportCriteria dlg = new DlgProlongedTransfusionReportCriteria();

            if (dlg.ShowDialog(this) != DialogResult.OK)
                return;

            if (dlg.ProlongedTransfusionReport.IsScheduled)
            {
                if (!dlg.ProlongedTransfusionReport.IsValid)
                    throw (new BusinessObjectException(Common.StrRes.SysErrMsg.Common.UnableToGenerateReportBecauseSomeRulesAreBroken(dlg.ProlongedTransfusionReport.BrokenRulesCount, dlg.ProlongedTransfusionReport.GetType().Name).ResString));

                dlg.ProlongedTransfusionReport.Schedule();
            }
            else
            {
                DisplayMdiChildForm(new FrmProlongedTransfusionReport(dlg.ProlongedTransfusionReport));
            }
		}

		private void mnuTransfusionReactionCountReport_Click(object sender, System.EventArgs e)
		{
			DlgTransfusionReactionCountReportCriteria dlg = new DlgTransfusionReactionCountReportCriteria();
			if( dlg.ShowDialog(this) != DialogResult.OK )
			{
				return;
			}
			if(dlg.TransfusionReactionReport.IsScheduled)
			{
				dlg.TransfusionReactionReport.Schedule();
			}
			else
			{
				DisplayMdiChildForm( new FrmTransfusionReactionCountReport(dlg.TransfusionReactionReport) );
			}
		}

		private void mnuAdministrativeDataReport_Click(object sender, System.EventArgs e)
		{
			DlgAdministrativeDataReportCriteria dlg = new DlgAdministrativeDataReportCriteria();
			if( dlg.ShowDialog(this) != DialogResult.OK )
			{
				return;
			}
			if( dlg.AdminDataReport.IsScheduled)
				dlg.AdminDataReport.Schedule();
			else
				DisplayMdiChildForm( new FrmAdministrativeDataReport(dlg.AdminDataReport, dlg.AdminDataReportData) );
		}

		private void mnuOrderHistoryReport_Click(object sender, System.EventArgs e)
		{
			DlgOrderReportCriteria dlg = new DlgOrderReportCriteria();
			if( dlg.ShowDialog(this) != DialogResult.OK )
			{
				return;
			}
			DisplayMdiChildForm(new FrmOrderHistoryReport(dlg.OrderReport));
		}

		#endregion

		#region Tools Menu
		
		private void mnuComponentClasses_Click(object sender, System.EventArgs e)
		{
			if( IsCurrentUserAuthorizedForFunction( FunctionCode.EditConsultativeReports ) )
				DisplayMdiChildForm( new FrmConfigureComponents() );
			else
				DisplayInsufficientPrivilegesMessageForMenuItem( mnuComponentClasses );
		}

		private void mnuTransfusionEffectiveness_Click(object sender, System.EventArgs e)
		{
			if( IsCurrentUserAuthorizedForFunction( FunctionCode.EditConsultativeReports ) )
				DisplayMdiChildForm( new FrmDefineEffectivenessTests() );
			else
				DisplayInsufficientPrivilegesMessageForMenuItem( mnuTransfusionEffectiveness );
		}

		private void mnuWorkloadCodes_Click(object sender, System.EventArgs e)
		{
			if( !VistALink.EnsureAvailability() )
				return;

			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.AssignWorkLoadCodes))
			{
				DisplayMdiChildForm( new FrmAssignWorkloadCodes() );
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void mnuAntibodies_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.EditAntigenFrequencyTable))
			{
				DisplayMdiChildForm( new DlgMaintainAntibodies() );
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void mnuBloodProducts_Click(object sender, System.EventArgs e)
		{
			if( !VistALink.EnsureAvailability() )
				return;

			DisplayMdiChildForm( new FrmBloodProductEdit() );
		}

		private void mnuCollectionFacilities_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmCollectionFacilityMaintain() );
		}

		private void mnuCannedComments_Click(object sender, System.EventArgs e)
		{
			if( IsCurrentUserAuthorizedForFunction( FunctionCode.EditAndCreateCannedComments ) )
				DisplayMdiChildForm( new FrmMaintainComments() );
			else
				DisplayInsufficientPrivilegesMessageForMenuItem( mnuCannedComments );
		}

		private void mnuTransfusionComplicationns_Click(object sender, System.EventArgs e)
		{
			if( IsCurrentUserAuthorizedForFunction( FunctionCode.EditConsultativeReports ) )
				DisplayMdiChildForm( new FrmMaintainComplications() );
			else
				DisplayInsufficientPrivilegesMessageForMenuItem( mnuTransfusionComplicationns );
		}

		private void mnuUpdateUsers_Click(object sender, System.EventArgs e)
		{
			if(	IsCurrentUserAuthorizedForAnyOfFunctions( FunctionCode.DefineVBECSUsers, FunctionCode.PrintInternalReports ) )
				DisplayMdiChildForm( new FrmUpdateUser() );
			else
				DisplayInsufficientPrivilegesMessageForMenuItem( mnuUpdateUsers );
		}

		private void mnuConfigureDivision_Click(object sender, System.EventArgs e)
		{
			if( IsCurrentUserAuthorizedForAnyOfFunctions( 
				FunctionCode.DefineValidUnitModifications, 
				FunctionCode.EnableElectronicXMatch, 
				FunctionCode.PopulateICCBBANumber,
				FunctionCode.ConfigureDivision,
				FunctionCode.MaintainLoginMessage,
				FunctionCode.ConfigureTesting) 
				)
			{
				DisplayMdiChildForm( new DlgMaintainDivision() );
			}
			else
			{
				DisplayInsufficientPrivilegesMessageForMenuItem( mnuConfigureDivision );
			}
		}

		private void mnuMSBOS_Click(object sender, System.EventArgs e)
		{
			if( IsCurrentUserAuthorizedForFunction( FunctionCode.EditConsultativeReports ) )
				DisplayMdiChildForm( new DlgMaintainMsbos() );
			else
				DisplayInsufficientPrivilegesMessageForMenuItem( mnuMSBOS );
		}

		private void mnuPrintBackupForms_Click(object sender, System.EventArgs e)
		{
			new DlgPrintBackupForms().ShowDialog( this );
		}

		private void mnuLogInSupplies_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmLogInSupplies() );
		}

		private void mnuUpdateSupplyInventory_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmRecordSupplyUsage() );
		}

		private void mnuViewPrintSupplyInventory_Click(object sender, System.EventArgs e)
		{
			DlgSupplyInventoryCriteria dlg = new DlgSupplyInventoryCriteria();
			if (dlg.ShowDialog(this) != DialogResult.OK)
			{
				return;
			}
			
			DisplayMdiChildForm( new FrmSupplyInventory(dlg.SupplyInventoryReport, dlg.SupplyInventoryReportData));
		}

		private void mnuLogInEquipment_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmNewEquipment() );
		}

		private void mnuMaintainEquipment_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmMaintainEquipment() );
		}

		#endregion

		#region Window Menu
		
		private void mnuCascade_Click(object sender, System.EventArgs e)
		{
			this.LayoutMdi( MdiLayout.Cascade );
		}

		private void mnuTileHorizontally_Click(object sender, System.EventArgs e)
		{
			this.LayoutMdi(MdiLayout.TileHorizontal);
		}

		private void mnuTileVertically_Click(object sender, System.EventArgs e)
		{
			this.LayoutMdi(MdiLayout.TileVertical);
		}

		private void mnuMinimizeAll_Click(object sender, System.EventArgs e)
		{
			foreach( Form _mdiChild in this.MdiChildren )
				_mdiChild.WindowState = FormWindowState.Minimized;	
		}

		#endregion

		#region Shipment Menu
		
		private void mnuIncomingShipment_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				// Determine the active child form.
				Form _activeChild = this.ActiveMdiChild;

				// If there is an active child form, and that child form is the same
				// function as the function they are trying to load again, disallow it.
				if( _activeChild != null && 
					( _activeChild.Name == "frmShipmentIn" || _activeChild.Name == "frmProcessShipmentIn" ) )
					return;

				DisplayMdiChildForm( new FrmShipmentIn() );
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void mnuNewOutgoingShipment_Click(object sender, System.EventArgs e)
		{
			new ProcessOutgoingShipment( ThisUser, this, true );
		}

		private void mnuRecentOutgoingShipmennt_Click(object sender, System.EventArgs e)
		{
			new ProcessOutgoingShipment( ThisUser, this, false );
		}

		private void mnuShipmentABORhConfirmation_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				FrmAboRHSelectInvoice _frmABORhInvoice = new FrmAboRHSelectInvoice(true);

				if( _frmABORhInvoice.ShowDialog( this ) == DialogResult.OK )
				{
					DisplayMdiChildForm( new FrmAboRHConfirmProcess( _frmABORhInvoice.ShipmentGuid, _frmABORhInvoice.TestDateTime, _frmABORhInvoice.TestUser, _frmABORhInvoice.AutomatedInstrName, _frmABORhInvoice.AutomatedInstrQCd, _frmABORhInvoice.RackGuid, _frmABORhInvoice.PerformAntiD, _frmABORhInvoice.RackNotQCComment) );
				}
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void mnuInvoiceDiscardQuarantineRelease_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				DlgDiscardQuarantineInvoice _dlgDiscardQuarantine = new DlgDiscardQuarantineInvoice();

				if( _dlgDiscardQuarantine.ShowDialog( this ) == DialogResult.OK )
					DisplayMdiChildForm( new FrmDiscardQuarantine( _dlgDiscardQuarantine.shipmentGuid ) );
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void mnuEditInvoiceText_Click(object sender, System.EventArgs e)
		{
			if( IsCurrentUserAuthorizedForFunction( FunctionCode.EditConsultativeReports ) )
				DisplayMdiChildForm( new FrmEditInvoiceText( ) );
			else
				DisplayInsufficientPrivilegesMessageForMenuItem( this.mnuPatientTesting );
		}

		#endregion

		#region Patients Menu
		
		private void mnuSIAndTRs_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmDefineTransfusionReqs() );
		}

		private void mnuPatientTesting_Click(object sender, System.EventArgs e)
		{
			if( IsCurrentUserAuthorizedForFunction( FunctionCode.StandardAccess ) )
				DisplayMdiChildForm( new FrmPendingTaskList( true ) );
			else
				DisplayInsufficientPrivilegesMessageForMenuItem( this.mnuPatientTesting );
		}

		private void mnuPatientBloodAvailability_Click(object sender, System.EventArgs e)
		{
			FrmReportBloodAvailability dlg = new FrmReportBloodAvailability();
			if (dlg.ShowDialog(this) != DialogResult.OK)
			{
				return;
			}
			//
			BOL.BloodAvailability ba = new BOL.BloodAvailability();
			ba.IsMultiDivisional = false;
			ba.IsIndividualPatientReport = true;
			ba.PatientGuid = dlg.Patient.PatientGuid;
			//Show the report.
			DisplayMdiChildForm( new DlgReportBloodAvailability(ba) );
		}

		private void mnuPrintTagFormPatient_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmPrintCautionTagByPatient() );
		}

		private void mnuIssueBlood_Click(object sender, System.EventArgs e)
		{
			FrmPatientSelect frm = new FrmPatientSelect( false );

			try
			{
				frm.ShowDialog( this );

				if ( frm.DialogResult != DialogResult.OK || frm.SelectedPatient == null )
					return;

				BOL.PatientUnitIssue pUI = new BOL.PatientUnitIssue( frm.SelectedPatient, ThisUser );

				if( !pUI.UnitsAvailable() )
				{
					if (pUI.AllUnitsInvalidMessage == string.Empty)
					{
						GuiMessenger.ShowMessageBox( Common.StrRes.InfoMsg.UC073.NoUnitsAvailable() );
					}
					else
					{
						GuiMessenger.ShowMessageBox( Common.StrRes.InfoMsg.UC073.NoValidUnits(pUI.AllUnitsInvalidMessage) ); 
					}
					return;
				}

				DlgIssueBloodDetails dIBUD = new DlgIssueBloodDetails(pUI);
				if (dIBUD.DialogResult != DialogResult.Abort)
				{
					dIBUD.ShowDialog( this );
				}
				
			}
			finally
			{
				if( frm != null )
					frm.Close();
			}
		}

		private void mnuInvalidatePatientTesting_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.EditPatientRecordVerifiedDataTestResults))
			{
				DisplayMdiChildForm( new FrmInvalidatePatientTestResults() );
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void mnuReturnIssuedUnitsForPatient_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				if( !VistALink.EnsureAvailability() ) return;

				DlgReturnUnitsInfo _dlgReturnUnitsInfo = new DlgReturnUnitsInfo();

				if( _dlgReturnUnitsInfo.ShowDialog( this ) == DialogResult.OK )
					DisplayMdiChildForm( new FrmReturnIssuedUnits(_dlgReturnUnitsInfo.ReturnedDateTime, _dlgReturnUnitsInfo.ReturnedTechId, false) );
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void mnuJustifyABORhChange_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmJustifyAboRHChange() );
		}
		
		private void mnuRecentOrders_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new DlgRecentOrders() );
		}

		private void mnuRecentTransfusionIssues_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new DlgRecentTransfusionsIssues() );
		}

		private void mnuTransfusionReactionHistory_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new DlgTransfusionReactionHistory() );
		}

		private void mnuPatientTestingWorklist_Click(object sender, System.EventArgs e)
		{
			FrmTestingWorklistSpecimens dlg = new FrmTestingWorklistSpecimens();

			if( dlg.ShowDialog(this) != DialogResult.OK )
			{
				return;
			}
			DisplayMdiChildForm( new FrmTestingWorklistReport(dlg.Patient,dlg.Specimens) );
		}

		/// <summary>
		/// mnuPostTransfusionDetails_Click
		/// </summary>
		private void mnuPostTransfusionDetails_Click(object sender, System.EventArgs e)
		{
			if ( IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess) )
			{
				DisplayMdiChildForm( new FrmEnterPostTransfusionInfo() );
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		/// <summary>
		/// mnuPatientMerge_Click
		/// </summary>
		private void mnuPatientMerge_Click(object sender, System.EventArgs e)
		{
			this._frmMergePatients = new FrmMergePatients();
			//
			this._frmMergePatients.ViewedMerges += new EventHandler( ViewedMerges );
			//
			DisplayMdiChildForm( this._frmMergePatients );
		}

		/// <summary>
		/// mnuUpdatedPatients_Click
		/// </summary>
		private void mnuUpdatedPatients_Click(object sender, System.EventArgs e)
		{
			this._frmViewUpdatedPatients = new FrmViewUpdatedPatients();
			//
			this._frmViewUpdatedPatients.ViewedUpdates += new EventHandler( ViewedUpdates );
			//
			DisplayMdiChildForm( this._frmViewUpdatedPatients );
		}

		/// <summary>
		/// mnnuDeceasedPatients_Click
		/// </summary>
		private void mnnuDeceasedPatients_Click(object sender, System.EventArgs e)
		{
			this._frmViewDeceasedPatients = new FrmViewDeceasedPatients();
			//
			this._frmViewDeceasedPatients.ViewedDeceased += new EventHandler( ViewedDeceased );
			//
			DisplayMdiChildForm( this._frmViewDeceasedPatients );
		}

		#endregion

		#region Edit Menu		

		private void mnuEdit_Popup(object sender, System.EventArgs e)
		{
            Control _currentControl = (Control)this.ActiveMdiChild;
            ContainerControl _container = _currentControl as ContainerControl;

            //CR 3554

            if (_container != null && _container.ActiveControl != null)
            {
                _currentControl = _container.ActiveControl;

                if (_currentControl == null || _currentControl as TextBoxBase == null)
                {
                    DisableEditCapabilities();
                    return;
                }

                _editMenuTextBox = _currentControl as TextBoxBase;
            }

            IDataObject iData = Clipboard.GetDataObject();
            this.mnuPaste.Enabled = iData.GetDataPresent(DataFormats.Text);

            //CR 3554
            int len = 0;
            int len2 = 0;
            bool undo = false;
            if (_editMenuTextBox != null)
            {
                len = _editMenuTextBox.SelectionLength;
                len2 = _editMenuTextBox.Text.Length;
                undo = _editMenuTextBox.CanUndo;
            }
            if (this.mnuCut != null && this.mnuCopy != null && mnuDelete != null && this.mnuUndo != null && this.mnuSelectAll != null)
            {
                this.mnuCut.Enabled =
                    this.mnuCopy.Enabled =
                        this.mnuDelete.Enabled = (len > 0);
                this.mnuUndo.Enabled = undo;
                this.mnuSelectAll.Enabled = (len2 > 0);
            }
		    
		}

		private void DisableEditCapabilities()
		{
			_editMenuTextBox = null;

			this.mnuCut.Enabled = 
				this.mnuCopy.Enabled =
				this.mnuPaste.Enabled =
				this.mnuDelete.Enabled =
				this.mnuUndo.Enabled =
				this.mnuSelectAll.Enabled = false;
		}

		private void mnuCut_Click(object sender, System.EventArgs e)
		{
			if(( _editMenuTextBox != null )&&(_editMenuTextBox.GetType() != typeof(System.Windows.Forms.DataGridTextBox)))
				_editMenuTextBox.Cut();
		}

		private void mnuCopy_Click(object sender, System.EventArgs e)
		{
			if(( _editMenuTextBox != null )&&(_editMenuTextBox.GetType() != typeof(System.Windows.Forms.DataGridTextBox)))
				_editMenuTextBox.Copy();
		}

		private void mnuPaste_Click(object sender, System.EventArgs e)
		{
			if(( _editMenuTextBox != null )&&(_editMenuTextBox.GetType() != typeof(System.Windows.Forms.DataGridTextBox)))
			{
				_editMenuTextBox.Paste();
			}
		}

		private void mnuUndo_Click(object sender, System.EventArgs e)
		{
			if( _editMenuTextBox != null && _editMenuTextBox.CanUndo )
			{
				_editMenuTextBox.Undo();
				_editMenuTextBox.ClearUndo();
			}
		}

		private void mnuSelectAll_Click(object sender, System.EventArgs e)
		{
			if (_editMenuTextBox != null)
				_editMenuTextBox.SelectAll();
		}

		private void mnuDelete_Click(object sender, System.EventArgs e)
		{
			if(( _editMenuTextBox != null ) && (!_editMenuTextBox.ReadOnly))
			{
				_editMenuTextBox.Text = _editMenuTextBox.Text.Remove(_editMenuTextBox.SelectionStart,_editMenuTextBox.SelectionLength);
			}
		}

		#endregion

		#region Supervisor Menu

		private void mnuRemoveFinalUnitStatus_Click(object sender, System.EventArgs e)
		{
			DisplayMdiChildForm( new FrmInvalidateFinalStatus() );
		}

		private void mnuDocumentABOIncompatibleTransfusion_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.EditBloodUnitLongitudinalRecord))
			{
				DisplayMdiChildForm( new FrmAboIncompatibleTransfusion() );
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		#endregion

		#endregion

		#region UC_84

		#region Methods

		/// <summary>
		/// AddOrdersToListView
		/// </summary>
		/// <param name="orders"></param>
		/// <param name="isComponentOrder"></param>
		private void AddOrdersToListView(DataTable orders, bool isComponentOrder)
		{
			this.pnlOrders.Size = new System.Drawing.Size(700, 200);
			this.lvOrders.SelectedItems.Clear();
			//
			foreach(DataRow dr in orders.Rows)
			{
				ListViewItem lvi = new ListViewItem();
				lvi.Tag = dr;
				lvi.ImageIndex = isComponentOrder ? 3 : 41;
				//
				lvi.SubItems.Add(dr[Common.VbecsTables.OrderUrgency.OrderUrgencyText].ToString());
				lvi.SubItems.Add(BOL.Patient.BuildDisplayName(dr[Common.VbecsTables.Patient.PatientFirstName].ToString(),
					dr[Common.VbecsTables.Patient.PatientMiddleName].ToString(),
					dr[Common.VbecsTables.Patient.PatientLastName].ToString()));
				lvi.SubItems.Add(dr[Common.VbecsTables.Patient.DisplayVistaPatientId].ToString());
				lvi.SubItems.Add(dr[Common.DatabaseConstants.ArtificialColumnNames.OrderedItem].ToString());
				//
				try
				{
					lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(dr[Common.DatabaseConstants.ArtificialColumnNames.WantedDate]));
				}
				catch
				{
					lvi.SubItems.Add("");
				}
				if (isComponentOrder)
				{
					lvi.SubItems.Add(dr[Common.VbecsTables.OrderedComponent.LabOrderNumber].ToString());
					lvi.SubItems.Add(dr[Common.VbecsTables.OrderedComponent.CprsOrderNumber].ToString());
				}
				else
				{
					lvi.SubItems.Add(dr[Common.VbecsTables.OrderedTest.LabOrderNumber].ToString());
					lvi.SubItems.Add(dr[Common.VbecsTables.OrderedTest.CprsOrderNumber].ToString());
				}
				//
				lvOrders.Items.Add(lvi);
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvOrders);
		}

		/// <summary>
		/// Detaches ViewedDeceased Event and sets 
		/// _frmViewDeceasedPatients form instance to null
		/// </summary>
		private void DetachViewDeceasedEvent()
		{
			// remove any existing events
			if (this._frmViewDeceasedPatients != null)
			{
				this._frmViewDeceasedPatients.ViewedDeceased -= new EventHandler( ViewedDeceased );
				//
				this._frmViewDeceasedPatients = null;
			}
		}

		/// <summary>
		/// Detaches ViewedMerges Event and sets 
		/// _frmMergePatients form instance to null
		/// </summary>
		private void DetachViewedMergesEvent()
		{
			// remove any existing events
			if (this._frmMergePatients != null)
			{
				this._frmMergePatients.ViewedMerges -= new EventHandler( ViewedMerges );
				//
				this._frmMergePatients = null;
			}
		}

		/// <summary>
		/// Detaches ViewUpdates Event and sets 
		/// _frmViewUpdatedPatients form instance to null
		/// </summary>
		private void DetachViewUpdatesEvent()
		{
			// remove any existing events
			if (this._frmViewUpdatedPatients != null)
			{
				this._frmViewUpdatedPatients.ViewedUpdates -= new EventHandler( ViewedUpdates );
				//
				this._frmViewUpdatedPatients = null;
			}
		}

		/// <summary>
		/// FlashOrderAlertIcon
		/// CR 3330
		/// </summary>
		private void FlashOrderAlertIcon()
		{
		    for (int i = 0; i < 3; i++)
		    {
                //
                if (_orderIconThread != null && _orderIconThread.IsAlive)
                {
                    this.Invoke(new MethodInvoker(delegate { statusBarPanelOrderAlert.Icon = controls.VbecsIcon.TransparentAlert.Icon; }));
                    Thread.Sleep(500);
                }
                //CR3400 - swapping these so the icon turns off first, and stays on after it's done blinking
                if (_orderIconThread != null && _orderIconThread.IsAlive)
			    {
                    this.Invoke(new MethodInvoker(delegate { statusBarPanelOrderAlert.Icon = controls.VbecsIcon.OrderAlert.Icon;}));
				    Thread.Sleep(500);
			    }

		    }
		}

		/// <summary>
		/// FlashPatientAlertIcon
		/// </summary>
		private void FlashPatientAlertIcon()
		{
			for (int i = 0; i < 3; i++)
			{
				if (_patientIconThread != null && _patientIconThread.IsAlive)
				{
                    this.Invoke(new MethodInvoker(delegate { statusBarPanelPatientAlert.Icon = controls.VbecsIcon.PatientAlert.Icon;}));
                    Thread.Sleep(500);
				}
				//
				if (_patientIconThread != null && _patientIconThread.IsAlive)
				{
                    this.Invoke(new MethodInvoker(delegate { statusBarPanelPatientAlert.Icon = controls.VbecsIcon.TransparentAlert.Icon; }));
					Thread.Sleep(500);
				}
			}
			//
            this.Invoke(new MethodInvoker(delegate { statusBarPanelPatientAlert.Icon = controls.VbecsIcon.PatientAlert.Icon; }));
		}

		/// <summary>
		/// StopAllTimers
		/// </summary>
		protected override void StopAllTimers()
		{
			_disableTimers = true;

			if( tmrOrderAlerts != null )
				tmrOrderAlerts.Stop();

			if( tmrPatientAlerts != null )
				tmrPatientAlerts.Stop();


			if( tmrDateTime != null )
				tmrDateTime.Stop();
		}

		/// <summary>
		/// StopAllWorkerThreads
		/// </summary>
		protected override void StopAllWorkerThreads()
		{			
			if( _orderIconThread != null )
				_orderIconThread.Abort();

			if( _patientIconThread != null )
				_patientIconThread.Abort();

			// CR 2519
			if( _purgeMessageLogThread != null )
				_purgeMessageLogThread.Abort();

			// CR 2958
			if( _dssExtractThread != null )
				_dssExtractThread.Abort();
		}

		/// <summary>
		/// UpdateOrderAlertStatusBarPanel
		/// </summary>
		private void UpdateOrderAlertStatusBarPanel()
		{
            //CR3400 - removing extra call to refresh Division - its now in patient altert refresh which is still overkill and good enough
		    if (this._division.DivisionAlerts.IconAlertsIndicator)
		    {
		        this.tmrOrderAlerts.Interval = (this._division.DivisionAlerts.IconRefreshRate*1000); //CR3400 - just in case another user updated it and got picked up in UpdatePatientAlertStatusBarPanel
		        DataTable orderedTests = BOL.OrderedTest.GetOrderAlerts(this._lastOrderUpdateCheck);
		        DataTable orderedComponent = BOL.OrderedComponent.GetOrderAlerts(this._lastOrderUpdateCheck);
		        int orderAlertCount = orderedTests.Rows.Count + orderedComponent.Rows.Count; //orders since last check

		        if (orderAlertCount > 0)
		        {
		            _orderIconThread = new Thread(new ThreadStart(FlashOrderAlertIcon));
		            _orderIconThread.Start();
		            this.Invoke(new MethodInvoker(delegate { statusBarPanelOrderAlert.ToolTipText = Common.StrRes.Tooltips.UC084.OrderUpdates(orderAlertCount).ResString; }));
		            if (Common.LogonUser.IsVisuallyImpairedUser)
		            {
		                this.SpeakMessage("Order Alerts exist press F 7 to view the order alerts");
		            }
		            _orderAlertIcon = true;
		        }
		        else
		        {
                    //CR3400 - they want to see the icon, but no orders doesn't mean hide the icon, so we do nothing unless the icon is invisible (users popped the mini grid)
                    if (statusBarPanelOrderAlert.Icon == controls.VbecsIcon.TransparentAlert.Icon) _orderAlertIcon = false;
		        }
		        //
		        AddOrdersToListView(orderedTests, false);
		        AddOrdersToListView(orderedComponent, true);

		    }
		    else
		    {
                this.Invoke(new MethodInvoker(delegate { statusBarPanelOrderAlert.Icon = controls.VbecsIcon.TransparentAlert.Icon; }));
                this.Invoke(new MethodInvoker(delegate { statusBarPanelOrderAlert.ToolTipText = string.Empty; }));
		    }
		    //
			this.tmrOrderAlerts.Enabled = true;
		}

		/// <summary>
		/// UpdatePatientAlertStatusBarPanel
		/// Implements BR_84.10
		/// </summary>
		private void UpdatePatientAlertStatusBarPanel()
		{
            //CR 2755 need to refresh the div obj in case someone just updated configure division and we havent refreshed our object yet
            //CR 3400 - moved from statusBar1_PanelClick - so it's done every 5 min with PatinetUpdate check.. which is more "behind-the-scenes"
            this._division.RefreshFromDb();

			bool isPatientUpdated = BOL.PatientChange.GetRecentlyUpdatedPatientCount() > 0;
			bool isPatientDeceased = BOL.PatientChange.GetRecentlyDeceasedPatientsCount() > 0;
			bool isPatientMerged = BOL.PatientChange.GetPendingPatientMergesCount() > 0;
			//
			//BR_84.10
			if (isPatientUpdated || isPatientDeceased || isPatientMerged)
			{
				_patientIconThread = new Thread(new ThreadStart(FlashPatientAlertIcon));
				_patientIconThread.Start();
				if(Common.LogonUser.IsVisuallyImpairedUser)
				{
					this.SpeakMessage("Patient Alerts exist press F 8 to view the patient alerts");
				}
				this._patientAlertIcon = true;
			}
			else
			{
				this._patientAlertIcon = false;
			}
			//
			if(_patientAlertToolTip == null)
			{
				_patientAlertToolTip = new StringBuilder();
			}
			else
			{
				_patientAlertToolTip.Remove(0, _patientAlertToolTip.Length);
			}
			//
			if (isPatientUpdated)
			{
				_patientAlertToolTip.Append(Common.StrRes.Tooltips.UC084.PatientUpdates().ResString);
				_patientAlertToolTip.Append("\n");
			}
			//
			if (isPatientDeceased)
			{
				_patientAlertToolTip.Append(Common.StrRes.Tooltips.UC084.PatientDeaths().ResString);
				_patientAlertToolTip.Append("\n");
			}
			//
			if (isPatientMerged)
			{
				_patientAlertToolTip.Append(Common.StrRes.Tooltips.UC084.PatientMerges().ResString);
				_patientAlertToolTip.Append("\n");
			}
			//
            this.Invoke(new MethodInvoker(delegate { statusBarPanelPatientAlert.ToolTipText = _patientAlertToolTip.ToString(); }));
			//
			// Enable if updates
			// Make sure user has security clearance to access merge 
			if (isPatientMerged && this.mnuPatientMerge.Enabled)
			{
				this.mnuPatientMergeToolbar.Enabled = true;
			}
			else
			{
				this.mnuPatientMergeToolbar.Enabled = false;
			}
			// 
			// Enable if updates
			// Make sure user has security clearance to access updated patient information 
			if (isPatientUpdated && this.mnuUpdatedPatients.Enabled)
			{
				this.mnuUpdatedPatientsToolbar.Enabled = true;
			}
			else
			{
				this.mnuUpdatedPatientsToolbar.Enabled = false;
			}
			//
			// Enable if updates
			// Make sure user has security clearance to access deceased patient information 
			if (isPatientDeceased && this.mnnuDeceasedPatients.Enabled)
			{
				this.mnuDeceasedPatientToolbar.Enabled = true;
			}
			else
			{
				this.mnuDeceasedPatientToolbar.Enabled = false;
			}
			//
			this.tmrPatientAlerts.Enabled = true;
			//
			if (isPatientUpdated || isPatientDeceased || isPatientMerged)
			{
                this.Invoke(new MethodInvoker(delegate { statusBarPanelPatientAlert.Icon = controls.VbecsIcon.PatientAlert.Icon; }));
			}
			else
			{
                this.Invoke(new MethodInvoker(delegate { statusBarPanelPatientAlert.Icon = controls.VbecsIcon.TransparentAlert.Icon; }));
			}
		}

	

		#endregion

		#region Events

		/// <summary>
		/// btnCloseOrders_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCloseOrders_Click(object sender, System.EventArgs e)
		{
			this.pnlOrders.Visible = false;
			this.lvOrders.Items.Clear();
		}

		/// <summary>
		/// lvOrders_ColumnClick
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvOrders_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 5)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender,e,false,controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender,e,false,controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		/// <summary>
		/// lvOrders_DoubleClick
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvOrders_DoubleClick(object sender, System.EventArgs e)
		{
			using (new WaitCursor())
			{
				if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
				{
					if( !VistALink.EnsureAvailability() )
						return;

					if (lvOrders.SelectedItems.Count > 0)
					{
						DataRow dr = (DataRow)this.lvOrders.SelectedItems[0].Tag;

						DisplayMdiChildForm( new FrmPendingOrderSearch(dr[Common.VbecsTables.OrderedTest.CprsOrderNumber].ToString()) );
					}
				}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
				}
			}

			this.pnlOrders.Visible = false;
			this.lvOrders.Items.Clear();
		}

		/// <summary>
		/// mnuDeceasedPatientToolbar_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void mnuDeceasedPatientToolbar_Click(object sender, System.EventArgs e)
		{
			mnnuDeceasedPatients_Click(sender,e);
		}

		/// <summary>
		/// mnuUpdatedPatientsToolbar_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void mnuUpdatedPatientsToolbar_Click(object sender, System.EventArgs e)
		{
			mnuUpdatedPatients_Click(sender,e);
		}

		/// <summary>
		/// mnuPatientMergeToolbar_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void mnuPatientMergeToolbar_Click(object sender, System.EventArgs e)
		{
			mnuPatientMerge_Click(sender,e);
		}

		/// <summary>
		/// tmrDateTime_Tick
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void tmrDateTime_Tick(object sender, System.EventArgs e)
		{
			if( _disableTimers )
			{
				tmrDateTime.Enabled = false;
				return;
			}

			this.UpdateTimeZoneStatusBarPanel();
		}

		/// <summary>
		/// statusBar1_PanelClick
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void statusBar1_PanelClick(object sender, System.Windows.Forms.StatusBarPanelClickEventArgs e)
		{
			if (e.StatusBarPanel == statusBarPanelOrderAlert)
			{
				this.Invoke(new MethodInvoker(delegate { statusBarPanelOrderAlert.ToolTipText = string.Empty; }));
                this.Invoke(new MethodInvoker(delegate { statusBarPanelOrderAlert.Icon = controls.VbecsIcon.TransparentAlert.Icon; }));     //CR3400
                this._orderAlertIcon = false;   //CR3400

			    if ((this._division.DivisionAlerts.IconAlertsIndicator) && (this.lvOrders.Items.Count > 0))
			    {
			        if (pnlOrders.Visible == false)
			        {
			            // Show orders list view
			            int x = (this.Width - pnlOrders.Width - 10); //10 for form trim  //CR3400 consistent with KeyDown behavior
			            int y = (this.statusBar1.Top - pnlOrders.Height);
			            if (x < 0)
			            {
			                x = 0;
			            }
			            pnlOrders.Location = new Point(x, y);
			            pnlOrders.Visible = true;
			            pnlOrders.Anchor = ((AnchorStyles) ((AnchorStyles.Bottom | AnchorStyles.Right))); //CR3400 Anchoring to help when parent is resizing 
			        }
			        else
			        {
			            // Hide orders list view
			            pnlOrders.Visible = false;
			            this.lvOrders.Items.Clear();
			        }
			    }
			}
			else if (e.StatusBarPanel == statusBarPanelPatientAlert)
			{
                //DR4963 - few more tweaks to make this behave consistent changing the location of the context menu, and NOT clearing the tooltip
                int x = this.statusBar1.Location.X + this.Width - this.statusBarPanelVistALink.Width - this.statusBarPanelPatientAlert.Width;
                cmnuPatientUpdates.Show(this.statusBar1, new Point(x, 0));
			}
		}

		/// <summary>
		/// tmrOrderAlerts_Tick
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void tmrOrderAlerts_Tick(object sender, System.EventArgs e)
		{
			this.tmrOrderAlerts.Enabled = false;

			if( _disableTimers )
				return;

			System.DateTime tickDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			this.UpdateOrderAlertStatusBarPanel();

			this._lastOrderUpdateCheck = tickDate;
		}

	
		/// <summary>
		/// tmrPatientAlerts_Tick
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void tmrPatientAlerts_Tick(object sender, System.EventArgs e)
		{			
			this.tmrPatientAlerts.Enabled = false;

			if( _disableTimers )
				return;

			System.DateTime tickDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			this.UpdatePatientAlertStatusBarPanel();

			this._lastPatientUpdateCheck = tickDate;
		}

		/// <summary>
		/// ViewedDeceased
		/// Implements BR_68.12
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ViewedDeceased(object sender, EventArgs e)
		{
			UpdatePatientAlertStatusBarPanel();
			//
			DetachViewDeceasedEvent();
		}

		/// <summary>
		/// ViewedMerges
		/// Implements BR_68.13
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ViewedMerges(object sender, EventArgs e)
		{
			UpdatePatientAlertStatusBarPanel();
			//
			DetachViewedMergesEvent();
		}

		/// <summary>
		/// ViewedUpdates
		/// Implements BR_68.12
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ViewedUpdates(object sender, EventArgs e)
		{
			UpdatePatientAlertStatusBarPanel();
			//
			DetachViewUpdatesEvent();
		}

		#endregion

		#endregion

		#region Purge MessageLog

		/// <summary>
		/// CR 2519
		/// </summary>
		private void PurgeHL7MessageLog()
		{
			if( _purgeMessageLogThread.IsAlive )
			{
				HL7MessageLog.PurgeMessageLog();
			}
		}

		#endregion

		#region Dss Extract Re-send

		/// <summary>
		/// CR 2958
		/// </summary>
		private void HandleDssExtract()
		{
			if( _dssExtractThread.IsAlive )
			{
				// Send any transfusion records to Dss that have not yet been processed successfully
				if ( VistALink.IsAvailable )
				{
					Guid [] guids = DAL.VAL.DssExtract.GetPatientTransfusionGuidsForDssExtract();
					//
					if ( guids != null && guids.Length > 0 )
					{
                        this.LockController.LockFunction = LockFunctions.DssExtract;
						if ( this.SetLocks(guids) )
						{
							DAL.VAL.DssExtract.UpdateVistADssExtract( Guid.Empty, Common.UpdateFunction.DssExtract );
						}
						this.UnlockAllRecords(); 
					}
				}
			}
		}

		#endregion

		private void lvOrders_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			//508 compliance
			this.SpeakListViewWithCheckBox(lvOrders);
		}

		private void FrmVbecs_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if ( Common.LogonUser.IsVisuallyImpairedUser && e != null && e.KeyCode == Keys.Escape )
			{
				pnlOrders.Visible = false;
			}
			//508 We are using F7 to display the order alert dialog
			if ( e != null && e.KeyCode == Keys.F7 )
			{
				this.Invoke(new MethodInvoker(delegate { statusBarPanelOrderAlert.ToolTipText = string.Empty; }));
                this.Invoke(new MethodInvoker(delegate { statusBarPanelOrderAlert.Icon = controls.VbecsIcon.TransparentAlert.Icon; }));
                this._orderAlertIcon = false;       //CR3400 - set flag to false, since we're hiding the icon
				if ((this._division.DivisionAlerts.IconAlertsIndicator) && (this.lvOrders.Items.Count>0))
				{
					if (pnlOrders.Visible == false)
					{
						// Show orders list view
					    int x = (this.Width - pnlOrders.Width - 10); //10 for form trim     //CR3400 - setting to be consistent with statuspanel_click
						int y = (this.statusBar1.Top - pnlOrders.Height);
						if (x<0)
						{
							x = 0;
						}
						pnlOrders.Location = new Point(x,y);
						pnlOrders.Visible = true;
                        pnlOrders.Anchor = ((AnchorStyles)((AnchorStyles.Bottom | AnchorStyles.Right)));        //CR3400 - helps when parent is resized
					}
					else
					{
						// Hide orders list view
						pnlOrders.Visible = false;
						this.lvOrders.Items.Clear();
					}
				}
				
			}
			//508 We are using F8 for patient allerts
			if ( e != null && e.KeyCode == Keys.F8 )
			{
                //DR4963 - few more tweaks to make this behave consistent changing the location of the context menu, and NOT clearing the tooltip
                int x = this.statusBar1.Location.X + this.Width - this.statusBarPanelVistALink.Width - this.statusBarPanelPatientAlert.Width;
                cmnuPatientUpdates.Show(this.statusBar1, new Point(x,0));
			}
			//508 We are using F6 to speak the status bar
			if (Common.LogonUser.IsVisuallyImpairedUser && e != null && e.KeyCode == Keys.F6 )
			{
				string vistaLink = string.Empty;
				string orderIcon = string.Empty;
				string patientIcon = string.Empty;

				if(_vistalinkAvailable)
				{
					vistaLink = "VistALink is available";
				}
				else
				{
					vistaLink = "VistALink is not available";
				}
				if(this._patientAlertIcon)
				{
					patientIcon = "Patient Alerts exist";
				}
				if(this._orderAlertIcon)
				{
					orderIcon = "Order Alerts exist";
				}
				
				
				string speakMsg = String.Concat(statusBarPanelUser.Text, " ", statusBarPanelDivision.Text, " ", statusBarPanelTimeZone.Text, " ", orderIcon, " ", patientIcon, " ", vistaLink);
				
				this.SpeakMessage(speakMsg);

			}
		}

	
	}
}	